/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.util.StringUtils;

public class LoadBalancerServiceInstanceCookieTransformer
implements LoadBalancerRequestTransformer {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ReactiveLoadBalancer.Factory<ServiceInstance> factory;

    public LoadBalancerServiceInstanceCookieTransformer(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ReactiveLoadBalancer.Factory<ServiceInstance> factory) {
        this.factory = factory;
    }

    public HttpRequest transformRequest(HttpRequest request, @Nullable ServiceInstance instance) {
        if (instance == null) {
            return request;
        }
        LoadBalancerProperties.StickySession stickySession = this.factory != null && this.factory.getProperties(instance.getServiceId()) != null ? this.factory.getProperties(instance.getServiceId()).getStickySession() : new LoadBalancerProperties.StickySession();
        if (!stickySession.isAddServiceInstanceCookie()) {
            return request;
        }
        String instanceIdCookieName = stickySession.getInstanceIdCookieName();
        if (!StringUtils.hasText((String)instanceIdCookieName)) {
            return request;
        }
        HttpHeaders headers = request.getHeaders();
        ArrayList<String> cookieHeaders = new ArrayList<String>(request.getHeaders().getOrEmpty("Cookie"));
        String serviceInstanceCookie = new HttpCookie(instanceIdCookieName, instance.getInstanceId()).toString();
        cookieHeaders.add(serviceInstanceCookie);
        headers.put("Cookie", cookieHeaders);
        return request;
    }
}

