/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.cache;

import com.stoyanr.evictor.ConcurrentMapWithTimedEviction;
import com.stoyanr.evictor.EvictionScheduler;
import com.stoyanr.evictor.map.ConcurrentHashMapWithTimedEviction;
import com.stoyanr.evictor.scheduler.DelayedTaskEvictionScheduler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.cache.Cache;
import org.springframework.cloud.loadbalancer.cache.DefaultLoadBalancerCache;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheProperties;
import org.springframework.cloud.loadbalancer.core.CachingServiceInstanceListSupplier;

public class DefaultLoadBalancerCacheManager
implements LoadBalancerCacheManager {
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>(16);

    public DefaultLoadBalancerCacheManager(LoadBalancerCacheProperties loadBalancerCacheProperties, String ... cacheNames) {
        this.cacheMap.putAll(this.createCaches(cacheNames, loadBalancerCacheProperties).stream().collect(Collectors.toMap(DefaultLoadBalancerCache::getName, cache -> cache)));
    }

    public DefaultLoadBalancerCacheManager(LoadBalancerCacheProperties loadBalancerCacheProperties) {
        this(loadBalancerCacheProperties, CachingServiceInstanceListSupplier.SERVICE_INSTANCE_CACHE_NAME);
    }

    private Set<DefaultLoadBalancerCache> createCaches(String[] cacheNames, LoadBalancerCacheProperties loadBalancerCacheProperties) {
        return Arrays.stream(cacheNames).distinct().map(name -> new DefaultLoadBalancerCache((String)name, (ConcurrentMapWithTimedEviction<Object, Object>)new ConcurrentHashMapWithTimedEviction(loadBalancerCacheProperties.getCapacity(), (EvictionScheduler)new DelayedTaskEvictionScheduler(this.aScheduledDaemonThreadExecutor())), loadBalancerCacheProperties.getTtl().toMillis(), false)).collect(Collectors.toSet());
    }

    private ScheduledExecutorService aScheduledDaemonThreadExecutor() {
        return Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        });
    }

    public @Nullable Cache getCache(String name) {
        return (Cache)this.cacheMap.get(name);
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }
}

