/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HealthCheckServiceInstanceListSupplier
implements ServiceInstanceListSupplier,
InitializingBean,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(HealthCheckServiceInstanceListSupplier.class);
    private final ServiceInstanceListSupplier delegate;
    private final LoadBalancerProperties.HealthCheck healthCheck;
    private final WebClient webClient;
    private final String defaultHealthCheckPath;
    private final Flux<List<ServiceInstance>> aliveInstancesReplay;
    private Disposable healthCheckDisposable;

    public HealthCheckServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, LoadBalancerProperties.HealthCheck healthCheck, WebClient webClient) {
        this.delegate = delegate;
        this.healthCheck = healthCheck;
        this.defaultHealthCheckPath = healthCheck.getPath().getOrDefault("default", "/actuator/health");
        this.webClient = webClient;
        this.aliveInstancesReplay = Flux.defer((Supplier)delegate).delaySubscription(Duration.ofMillis(this.healthCheck.getInitialDelay())).switchMap(serviceInstances -> this.healthCheckFlux((List<ServiceInstance>)serviceInstances).map(alive -> Collections.unmodifiableList(new ArrayList(alive)))).replay(1).refCount(1);
    }

    public void afterPropertiesSet() {
        Disposable healthCheckDisposable = this.healthCheckDisposable;
        if (healthCheckDisposable != null) {
            healthCheckDisposable.dispose();
        }
        this.healthCheckDisposable = this.aliveInstancesReplay.subscribe();
    }

    protected Flux<List<ServiceInstance>> healthCheckFlux(List<ServiceInstance> instances) {
        return Flux.defer(() -> {
            ArrayList<Mono> checks = new ArrayList<Mono>(instances.size());
            for (ServiceInstance instance : instances) {
                Mono alive2 = this.isAlive(instance).onErrorResume(error -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Exception occurred during health check of the instance for service %s: %s", instance.getServiceId(), instance.getUri()), error);
                    }
                    return Mono.empty();
                }).timeout(this.healthCheck.getInterval(), Mono.defer(() -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("The instance for service %s: %s did not respond for %s during health check", instance.getServiceId(), instance.getUri(), this.healthCheck.getInterval()));
                    }
                    return Mono.empty();
                })).handle((isHealthy, sink) -> {
                    if (isHealthy.booleanValue()) {
                        sink.next((Object)instance);
                    }
                });
                checks.add(alive2);
            }
            ArrayList result = new ArrayList();
            return Flux.merge(checks).map(alive -> {
                result.add(alive);
                return result;
            }).defaultIfEmpty(result);
        }).repeatWhen(restart -> restart.delayElements(this.healthCheck.getInterval()));
    }

    @Override
    public String getServiceId() {
        return this.delegate.getServiceId();
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return this.aliveInstancesReplay;
    }

    protected Mono<Boolean> isAlive(ServiceInstance serviceInstance) {
        String healthCheckPropertyValue = (String)this.healthCheck.getPath().get(serviceInstance.getServiceId());
        String healthCheckPath = healthCheckPropertyValue != null ? healthCheckPropertyValue : this.defaultHealthCheckPath;
        return this.webClient.get().uri(UriComponentsBuilder.fromUri((URI)serviceInstance.getUri()).path(healthCheckPath).build().toUri()).exchange().flatMap(clientResponse -> clientResponse.releaseBody().thenReturn((Object)(HttpStatus.OK.value() == clientResponse.rawStatusCode() ? 1 : 0)));
    }

    public void destroy() {
        Disposable healthCheckDisposable = this.healthCheckDisposable;
        if (healthCheckDisposable != null) {
            healthCheckDisposable.dispose();
        }
    }
}

