/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.config;

import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.AsyncLoadBalancerAutoConfiguration;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.loadbalancer.config.LoadBalancerAutoConfiguration;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Primary;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@LoadBalancerClients
@AutoConfigureAfter(value={LoadBalancerAutoConfiguration.class})
@AutoConfigureBefore(value={org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration.class, AsyncLoadBalancerAutoConfiguration.class})
public class BlockingLoadBalancerClientAutoConfiguration {
    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient"})
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.ribbon.enabled"}, matchIfMissing=true)
    public BlockingLoadBalancerClientRibbonWarnLogger blockingLoadBalancerClientRibbonWarnLogger() {
        return new BlockingLoadBalancerClientRibbonWarnLogger();
    }

    static class BlockingLoadBalancerClientRibbonWarnLogger {
        private static final Log LOG = LogFactory.getLog(BlockingLoadBalancerClientRibbonWarnLogger.class);

        BlockingLoadBalancerClientRibbonWarnLogger() {
        }

        @PostConstruct
        void logWarning() {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("You already have RibbonLoadBalancerClient on your classpath. It will be used by default. As Spring Cloud Ribbon is in maintenance mode. We recommend switching to " + BlockingLoadBalancerClient.class.getSimpleName() + " instead. In order to use it, set the value of `spring.cloud.loadbalancer.ribbon.enabled` to `false` or remove spring-cloud-starter-netflix-ribbon from your project."));
            }
        }
    }

    private static final class OnNoRibbonDefaultCondition
    extends AnyNestedCondition {
        private OnNoRibbonDefaultCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingClass(value={"org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient"})
        static class RibbonLoadBalancerNotPresent {
            RibbonLoadBalancerNotPresent() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.ribbon.enabled"}, havingValue="false")
        static class RibbonNotEnabled {
            RibbonNotEnabled() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestTemplate.class})
    @Conditional(value={OnNoRibbonDefaultCondition.class})
    protected static class BlockingLoadbalancerClientConfig {
        protected BlockingLoadbalancerClientConfig() {
        }

        @Bean
        @ConditionalOnBean(value={LoadBalancerClientFactory.class})
        @Primary
        public BlockingLoadBalancerClient blockingLoadBalancerClient(LoadBalancerClientFactory loadBalancerClientFactory) {
            return new BlockingLoadBalancerClient(loadBalancerClientFactory);
        }
    }
}

