/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.ribbon.KubernetesConfigKey;

public class KubernetesServerList
extends AbstractServerList<Server>
implements ServerList<Server> {
    private static final int FIRST = 0;
    private static final Log LOG = LogFactory.getLog(KubernetesServerList.class);
    private final KubernetesClient client;
    private String serviceId;
    private String namespace;
    private String portName;

    public KubernetesServerList(KubernetesClient client) {
        this.client = client;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.serviceId = clientConfig.getClientName();
        this.namespace = clientConfig.getPropertyAsString(KubernetesConfigKey.Namespace, this.client.getNamespace());
        this.portName = clientConfig.getPropertyAsString(KubernetesConfigKey.PortName, null);
    }

    public List<Server> getInitialListOfServers() {
        return Collections.emptyList();
    }

    public List<Server> getUpdatedListOfServers() {
        Endpoints endpoints = this.namespace != null ? (Endpoints)((Resource)((NonNamespaceOperation)this.client.endpoints().inNamespace(this.namespace)).withName(this.serviceId)).get() : (Endpoints)((Resource)this.client.endpoints().withName(this.serviceId)).get();
        ArrayList<Server> result = new ArrayList<Server>();
        if (endpoints != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found [" + endpoints.getSubsets().size() + "] endpoints in namespace [" + this.namespace + "] for name [" + this.serviceId + "] and portName [" + this.portName + "]"));
            }
            for (EndpointSubset subset : endpoints.getSubsets()) {
                if (subset.getPorts().size() == 1) {
                    EndpointPort port = (EndpointPort)subset.getPorts().get(0);
                    for (EndpointAddress address : subset.getAddresses()) {
                        result.add(new Server(address.getIp(), port.getPort().intValue()));
                    }
                    continue;
                }
                for (EndpointPort port : subset.getPorts()) {
                    if (!Utils.isNullOrEmpty((String)this.portName) && !this.portName.endsWith(port.getName())) continue;
                    for (EndpointAddress address : subset.getAddresses()) {
                        result.add(new Server(address.getIp(), port.getPort().intValue()));
                    }
                }
            }
        } else {
            LOG.warn((Object)("Did not find any endpoints in ribbon in namespace [" + this.namespace + "] for name [" + this.serviceId + "] and portName [" + this.portName + "]"));
        }
        return result;
    }
}

