/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesConfigEnabled;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesSecretsEnabled;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesConfigRetryDisabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesSecretsRetryDisabled;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesBootstrapConfiguration;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesEnabled
@Import(value={KubernetesCommonsAutoConfiguration.class, Fabric8AutoConfiguration.class})
@ConditionalOnClass(value={ConfigMap.class, Secret.class})
@AutoConfigureAfter(value={KubernetesBootstrapConfiguration.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
public class Fabric8BootstrapConfiguration {
    @Bean
    public KubernetesNamespaceProvider provider(Environment env) {
        return new KubernetesNamespaceProvider(env);
    }

    @Bean
    @ConditionalOnKubernetesConfigEnabled
    @ConditionalOnKubernetesConfigRetryDisabled
    public Fabric8ConfigMapPropertySourceLocator configMapPropertySourceLocator(ConfigMapConfigProperties properties, KubernetesClient client, KubernetesNamespaceProvider provider) {
        return new Fabric8ConfigMapPropertySourceLocator(client, properties, provider);
    }

    @Bean
    @ConditionalOnKubernetesSecretsEnabled
    @ConditionalOnKubernetesSecretsRetryDisabled
    public Fabric8SecretsPropertySourceLocator secretsPropertySourceLocator(SecretsConfigProperties properties, KubernetesClient client, KubernetesNamespaceProvider provider) {
        return new Fabric8SecretsPropertySourceLocator(client, properties, provider);
    }
}

