/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.discovery.DefaultIsServicePortSecureResolver;
import org.springframework.cloud.kubernetes.discovery.KubernetesCatalogWatch;
import org.springframework.cloud.kubernetes.discovery.KubernetesClientServicesFunction;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.registry.KubernetesRegistration;
import org.springframework.cloud.kubernetes.registry.KubernetesServiceRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class})
public class KubernetesDiscoveryClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DefaultIsServicePortSecureResolver isServicePortSecureResolver(KubernetesDiscoveryProperties properties) {
        return new DefaultIsServicePortSecureResolver(properties);
    }

    @Bean
    public KubernetesClientServicesFunction servicesFunction(KubernetesDiscoveryProperties properties) {
        if (properties.getServiceLabels().isEmpty()) {
            return KubernetesClient::services;
        }
        return client -> (FilterWatchListDeletable)client.services().withLabels(properties.getServiceLabels());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.cloud.kubernetes.discovery.enabled"}, matchIfMissing=true)
    public KubernetesDiscoveryClient kubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties, KubernetesClientServicesFunction kubernetesClientServicesFunction, DefaultIsServicePortSecureResolver isServicePortSecureResolver) {
        return new KubernetesDiscoveryClient(client, properties, kubernetesClientServicesFunction, isServicePortSecureResolver);
    }

    @Bean
    public KubernetesServiceRegistry getServiceRegistry() {
        return new KubernetesServiceRegistry();
    }

    @Bean
    public KubernetesRegistration getRegistration(KubernetesClient client, KubernetesDiscoveryProperties properties) {
        return new KubernetesRegistration(client, properties);
    }

    @Bean
    public KubernetesDiscoveryProperties getKubernetesDiscoveryProperties() {
        return new KubernetesDiscoveryProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.cloud.kubernetes.discovery.catalog-services-watch.enabled"}, matchIfMissing=true)
    public KubernetesCatalogWatch kubernetesCatalogWatch(KubernetesClient client) {
        return new KubernetesCatalogWatch(client);
    }
}

