/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClient;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Scheduled;

public class KubernetesCatalogWatch
implements ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesCatalogWatch.class);
    private final KubernetesDiscoveryClient kubernetesDiscoveryClient;
    private final AtomicReference<List<String>> catalogServicesState = new AtomicReference();
    private ApplicationEventPublisher publisher;

    public KubernetesCatalogWatch(KubernetesDiscoveryClient kubernetesDiscoveryClient) {
        this.kubernetesDiscoveryClient = kubernetesDiscoveryClient;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Scheduled(fixedDelayString="${spring.cloud.kubernetes.discovery.catalogServicesWatchDelay:30000}")
    public void catalogServicesWatch() {
        try {
            List<String> previousState = this.catalogServicesState.get();
            List<String> services = this.kubernetesDiscoveryClient.getServices();
            services.sort(String::compareTo);
            this.catalogServicesState.set(services);
            if (!services.equals(previousState)) {
                logger.trace("Received services update from kubernetesDiscoveryClient: {}", services);
                this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, services));
            }
        }
        catch (Exception e) {
            logger.error("Error watching Kubernetes Services", (Throwable)e);
        }
    }
}

