/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.kubernetes.reload.enabled"}, havingValue="false", matchIfMissing=true)
class ConfigUpdateStrategyAutoConfiguration {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ConfigUpdateStrategyAutoConfiguration.class));

    ConfigUpdateStrategyAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    ConfigurationUpdateStrategy noopConfigurationUpdateStrategy() {
        LOG.debug(() -> "creating NOOP strategy because reload is disabled");
        return ConfigurationUpdateStrategy.NOOP;
    }
}

