/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.kubernetes.client.discovery.reactive.KubernetesInformerReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.configuration.watcher.BusRefreshTrigger;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.configuration.watcher.HttpRefreshTrigger;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
class RefreshTriggerAutoConfiguration {
    RefreshTriggerAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @Profile(value={"bus-amqp", "bus-kafka"})
    BusRefreshTrigger busRefreshTrigger(ApplicationEventPublisher applicationEventPublisher, BusProperties busProperties) {
        return new BusRefreshTrigger(applicationEventPublisher, busProperties.getId());
    }

    @Bean
    @ConditionalOnMissingBean
    @Profile(value={"!bus-amqp & !bus-kafka"})
    HttpRefreshTrigger httpRefreshTrigger(KubernetesInformerReactiveDiscoveryClient client, ConfigurationWatcherConfigurationProperties properties, WebClient webClient) {
        return new HttpRefreshTrigger(client, properties, webClient);
    }
}

