/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.reload.EventBasedSecretsChangeDetector;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import reactor.core.publisher.Mono;

public abstract class SecretsWatcherChangeDetector
extends EventBasedSecretsChangeDetector {
    protected Log log = LogFactory.getLog(this.getClass());
    private ScheduledExecutorService executorService;
    protected ConfigurationWatcherConfigurationProperties k8SConfigurationProperties;

    public SecretsWatcherChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        super(environment, properties, kubernetesClient, strategy, fabric8SecretsPropertySourceLocator);
        this.executorService = Executors.newScheduledThreadPool(k8SConfigurationProperties.getThreadPoolSize(), (ThreadFactory)threadPoolTaskExecutor);
        this.k8SConfigurationProperties = k8SConfigurationProperties;
    }

    protected boolean isSpringCloudKubernetesSecret(Secret secret) {
        if (secret.getMetadata() == null || secret.getMetadata().getLabels() == null) {
            return false;
        }
        return Boolean.parseBoolean(secret.getMetadata().getLabels().getOrDefault(this.k8SConfigurationProperties.getSecretLabel(), "false"));
    }

    protected abstract Mono<Void> triggerRefresh(Secret var1);

    protected void onEvent(Secret secret) {
        if (this.isSpringCloudKubernetesSecret(secret)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Scheduling remote refresh event to be published for Secret " + secret.getMetadata().getName() + " to be published in " + this.k8SConfigurationProperties.getRefreshDelay().toMillis() + " milliseconds"));
            }
            this.executorService.schedule(() -> this.triggerRefresh(secret).subscribe(), this.k8SConfigurationProperties.getRefreshDelay().toMillis(), TimeUnit.MILLISECONDS);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Not publishing event. Secret " + secret.getMetadata().getName() + " does not contain the label " + this.k8SConfigurationProperties.getSecretLabel()));
        }
    }
}

