/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configserver;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.ConfigServerAutoConfiguration;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigContext;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySource;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesConfigEnabled;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesSecretsEnabled;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.NamedConfigMapNormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.NamedSecretNormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.configserver.KubernetesConfigServerProperties;
import org.springframework.cloud.kubernetes.configserver.KubernetesEnvironmentRepository;
import org.springframework.cloud.kubernetes.configserver.KubernetesEnvironmentRepositoryFactory;
import org.springframework.cloud.kubernetes.configserver.KubernetesPropertySourceSupplier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@AutoConfigureAfter(value={KubernetesClientAutoConfiguration.class})
@AutoConfigureBefore(value={ConfigServerAutoConfiguration.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@EnableConfigurationProperties(value={KubernetesConfigServerProperties.class})
public class KubernetesConfigServerAutoConfiguration {
    @Bean
    @Profile(value={"kubernetes"})
    @ConditionalOnMissingBean
    public KubernetesEnvironmentRepository kubernetesEnvironmentRepository(CoreV1Api coreV1Api, List<KubernetesPropertySourceSupplier> kubernetesPropertySourceSuppliers, KubernetesNamespaceProvider kubernetesNamespaceProvider, KubernetesConfigServerProperties kubernetesConfigServerProperties) {
        return new KubernetesEnvironmentRepository(coreV1Api, kubernetesPropertySourceSuppliers, kubernetesNamespaceProvider.getNamespace(), kubernetesConfigServerProperties);
    }

    @Bean
    @ConditionalOnBean(value={KubernetesEnvironmentRepository.class})
    @ConditionalOnMissingBean
    public KubernetesEnvironmentRepositoryFactory kubernetesEnvironmentRepositoryFactory(KubernetesEnvironmentRepository kubernetesEnvironmentRepository) {
        return new KubernetesEnvironmentRepositoryFactory(kubernetesEnvironmentRepository);
    }

    @Bean
    @ConditionalOnKubernetesConfigEnabled
    @ConditionalOnProperty(value={"spring.cloud.kubernetes.config.enableApi"}, matchIfMissing=true)
    public KubernetesPropertySourceSupplier configMapPropertySourceSupplier(KubernetesConfigServerProperties properties) {
        return (coreApi, applicationName, namespace, springEnv) -> {
            List<String> namespaces = KubernetesPropertySourceSupplier.namespaceSplitter(properties.getConfigMapNamespaces(), namespace);
            ArrayList propertySources = new ArrayList();
            namespaces.forEach(space -> {
                NamedConfigMapNormalizedSource source = new NamedConfigMapNormalizedSource(applicationName, space, false, ConfigUtils.Prefix.DEFAULT, true, true);
                KubernetesClientConfigContext context = new KubernetesClientConfigContext(coreApi, (NormalizedSource)source, space, springEnv, false);
                propertySources.add(new KubernetesClientConfigMapPropertySource(context));
            });
            return propertySources;
        };
    }

    @Bean
    @ConditionalOnKubernetesSecretsEnabled
    @ConditionalOnProperty(value={"spring.cloud.kubernetes.secrets.enableApi"})
    public KubernetesPropertySourceSupplier secretsPropertySourceSupplier(KubernetesConfigServerProperties properties) {
        return (coreApi, applicationName, namespace, springEnv) -> {
            List<String> namespaces = KubernetesPropertySourceSupplier.namespaceSplitter(properties.getSecretsNamespaces(), namespace);
            ArrayList propertySources = new ArrayList();
            namespaces.forEach(space -> {
                NamedSecretNormalizedSource source = new NamedSecretNormalizedSource(applicationName, space, false, ConfigUtils.Prefix.DEFAULT, true, true);
                KubernetesClientConfigContext context = new KubernetesClientConfigContext(coreApi, (NormalizedSource)source, space, springEnv, false);
                propertySources.add(new KubernetesClientSecretsPropertySource(context));
            });
            return propertySources;
        };
    }
}

