/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configserver;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.kubernetes.configserver.KubernetesPropertySourceSupplier;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

public class KubernetesEnvironmentRepository
implements EnvironmentRepository {
    private static final Log LOG = LogFactory.getLog(KubernetesEnvironmentRepository.class);
    private CoreV1Api coreApi;
    private List<KubernetesPropertySourceSupplier> kubernetesPropertySourceSuppliers;
    private String namespace;

    public KubernetesEnvironmentRepository(CoreV1Api coreApi, List<KubernetesPropertySourceSupplier> kubernetesPropertySourceSuppliers, String namespace) {
        this.coreApi = coreApi;
        this.kubernetesPropertySourceSuppliers = kubernetesPropertySourceSuppliers;
        this.namespace = namespace;
    }

    public Environment findOne(String application, String profile, String label) {
        return this.findOne(application, profile, label, true);
    }

    public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        LOG.info((Object)("Profiles: " + profile));
        LOG.info((Object)("Application: " + application));
        LOG.info((Object)("Label: " + label));
        Environment environment = new Environment(application, profiles, label, null, null);
        try {
            StandardEnvironment springEnv = new StandardEnvironment();
            springEnv.setActiveProfiles(profiles);
            this.addApplicationConfiguration(environment, springEnv, "application");
            if (!"application".equalsIgnoreCase(application)) {
                this.addApplicationConfiguration(environment, springEnv, application);
            }
            return environment;
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            return environment;
        }
    }

    private void addApplicationConfiguration(Environment environment, StandardEnvironment springEnv, String applicationName) {
        this.kubernetesPropertySourceSuppliers.stream().forEach(supplier -> {
            List propertySources = supplier.get(this.coreApi, applicationName, this.namespace, (org.springframework.core.env.Environment)springEnv);
            propertySources.forEach(propertySource -> {
                if (propertySource.getPropertyNames().length > 0) {
                    LOG.debug((Object)("Adding PropertySource " + propertySource.getName()));
                    LOG.debug((Object)("PropertySource Names: " + StringUtils.arrayToCommaDelimitedString((Object[])propertySource.getPropertyNames())));
                    environment.add(new PropertySource(propertySource.getName(), (Map)propertySource.getSource()));
                }
            });
        });
    }
}

