/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config.reload;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.time.Duration;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.task.TaskSchedulerBuilder;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.config.SecretsPropertySource;
import org.springframework.cloud.kubernetes.config.SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public class PollingConfigurationChangeDetector
extends ConfigurationChangeDetector {
    protected Log log = LogFactory.getLog(this.getClass());
    private ConfigMapPropertySourceLocator configMapPropertySourceLocator;
    private SecretsPropertySourceLocator secretsPropertySourceLocator;
    private TaskScheduler taskExecutor;
    private Duration period = Duration.ofMillis(1500L);

    @Deprecated
    public PollingConfigurationChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, ConfigMapPropertySourceLocator configMapPropertySourceLocator, SecretsPropertySourceLocator secretsPropertySourceLocator) {
        super((ConfigurableEnvironment)environment, properties, kubernetesClient, strategy);
        this.configMapPropertySourceLocator = configMapPropertySourceLocator;
        this.secretsPropertySourceLocator = secretsPropertySourceLocator;
        this.taskExecutor = new TaskSchedulerBuilder().build();
    }

    public PollingConfigurationChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, ConfigMapPropertySourceLocator configMapPropertySourceLocator, SecretsPropertySourceLocator secretsPropertySourceLocator, TaskScheduler taskExecutor, ConfigReloadProperties configReloadProperties) {
        super((ConfigurableEnvironment)environment, properties, kubernetesClient, strategy);
        this.configMapPropertySourceLocator = configMapPropertySourceLocator;
        this.secretsPropertySourceLocator = secretsPropertySourceLocator;
        this.taskExecutor = taskExecutor;
        this.period = configReloadProperties.getPeriod();
    }

    @PostConstruct
    public void init() {
        this.log.info((Object)"Kubernetes polling configuration change detector activated");
        PeriodicTrigger trigger = new PeriodicTrigger(this.period.toMillis());
        trigger.setInitialDelay(this.period.toMillis());
        this.taskExecutor.schedule(this::executeCycle, (Trigger)trigger);
    }

    public void executeCycle() {
        List<MapPropertySource> currentSecretSources;
        List<ConfigMapPropertySource> currentConfigMapSources;
        boolean changedConfigMap = false;
        if (this.properties.isMonitoringConfigMaps() && this.configMapPropertySourceLocator != null && !(currentConfigMapSources = this.findPropertySources(ConfigMapPropertySource.class)).isEmpty()) {
            changedConfigMap = this.changed(this.locateMapPropertySources(this.configMapPropertySourceLocator, (Environment)this.environment), currentConfigMapSources);
        }
        boolean changedSecrets = false;
        if (this.properties.isMonitoringSecrets() && this.secretsPropertySourceLocator != null && (currentSecretSources = this.locateMapPropertySources(this.secretsPropertySourceLocator, (Environment)this.environment)) != null && !currentSecretSources.isEmpty()) {
            List<SecretsPropertySource> propertySources = this.findPropertySources(SecretsPropertySource.class);
            changedSecrets = this.changed(currentSecretSources, propertySources);
        }
        if (changedConfigMap || changedSecrets) {
            this.reloadProperties();
        }
    }
}

