/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.leader;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.cloud.kubernetes.commons.EnvReader;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.StringUtils;

public final class LeaderUtils {
    public static final String COORDINATION_GROUP = "coordination.k8s.io";
    public static final String COORDINATION_VERSION = "v1";
    public static final String LEASE = "Lease";
    public static final String LEADER_ELECTION_PROPERTY_PREFIX = "spring.cloud.kubernetes.leader.election";
    public static final String LEADER_ELECTION_ENABLED_PROPERTY = "spring.cloud.kubernetes.leader.election.enabled";
    private static final String POD_NAMESPACE = "POD_NAMESPACE";
    private static final LogAccessor LOG = new LogAccessor(LeaderUtils.class);
    private static final String HOSTNAME = "HOSTNAME";

    private LeaderUtils() {
    }

    public static Optional<String> podNamespace() {
        Path serviceAccountPath = new File("/var/run/secrets/kubernetes.io/serviceaccount/namespace").toPath();
        boolean serviceAccountNamespaceExists = Files.isRegularFile(serviceAccountPath, new LinkOption[0]);
        if (serviceAccountNamespaceExists) {
            try {
                String namespace = new String(Files.readAllBytes(serviceAccountPath)).replace(System.lineSeparator(), "");
                LOG.info(() -> "read namespace : " + namespace + " from service account " + String.valueOf(serviceAccountPath));
                return Optional.of(namespace);
            }
            catch (IOException e) {
                LOG.error((Throwable)e, () -> "error reading service account, will default to reading env variable : POD_NAMESPACE");
            }
        }
        return Optional.ofNullable(EnvReader.getEnv(POD_NAMESPACE));
    }

    public static String hostName() throws UnknownHostException {
        String hostName = EnvReader.getEnv(HOSTNAME);
        if (StringUtils.hasText((String)hostName)) {
            return hostName;
        }
        return InetAddress.getLocalHost().getHostName();
    }

    public static void guarded(ReentrantLock lock, Runnable runnable) {
        try {
            lock.lock();
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }
}

