/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class SourceDataFlattener {
    private SourceDataFlattener() {
    }

    static Map<String, Object> defaultFlattenedSourceData(LinkedHashMap<String, Map<String, Object>> sourceData) {
        HashMap<String, Object> flattenedData = new HashMap<String, Object>();
        sourceData.values().forEach(flattenedData::putAll);
        return flattenedData;
    }

    static Map<String, Object> prefixFlattenedSourceData(LinkedHashMap<String, Map<String, Object>> sourceData, String prefix) {
        HashMap<String, Object> flattenedData = new HashMap<String, Object>();
        sourceData.values().forEach(data -> data.forEach((key, value) -> flattenedData.put(prefix + "." + key, value)));
        return flattenedData;
    }

    static Map<String, Object> nameFlattenedSourceData(LinkedHashMap<String, Map<String, Object>> sourceData) {
        HashMap<String, Object> flattenedData = new HashMap<String, Object>();
        sourceData.forEach((name, data) -> data.forEach((key, value) -> flattenedData.put(name + "." + key, value)));
        return flattenedData;
    }
}

