/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.leader;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.kubernetes.leader")
public class LeaderProperties {
    private boolean enabled = true;
    private boolean autoStartup = true;
    private String role;
    private String namespace;
    private String configMapName = "leaders";
    private String leaderIdPrefix = "leader.id.";
    private Duration updatePeriod = Duration.ofMillis(60000L);
    private boolean publishFailedEvents = false;
    private boolean createConfigMap = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace(String defaultValue) {
        if (!StringUtils.hasText((String)defaultValue)) {
            return defaultValue;
        }
        return this.namespace;
    }

    public String getConfigMapName() {
        return this.configMapName;
    }

    public void setConfigMapName(String configMapName) {
        this.configMapName = configMapName;
    }

    public String getLeaderIdPrefix() {
        return this.leaderIdPrefix;
    }

    public void setLeaderIdPrefix(String leaderIdPrefix) {
        this.leaderIdPrefix = leaderIdPrefix;
    }

    public Duration getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(Duration updatePeriod) {
        this.updatePeriod = updatePeriod;
    }

    public boolean isPublishFailedEvents() {
        return this.publishFailedEvents;
    }

    public void setPublishFailedEvents(boolean publishFailedEvents) {
        this.publishFailedEvents = publishFailedEvents;
    }

    public boolean isCreateConfigMap() {
        return this.createConfigMap;
    }

    public void setCreateConfigMap(boolean createConfigMap) {
        this.createConfigMap = createConfigMap;
    }
}

