/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.leader.election;

import io.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.kubernetes.client.extended.leaderelection.LeaderElector;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BooleanSupplier;
import org.springframework.cloud.kubernetes.client.leader.election.KubernetesClientLeaderElectionCallbacks;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionInitiatorUtil;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionProperties;
import org.springframework.cloud.kubernetes.commons.leader.election.PodReadyRunner;
import org.springframework.core.log.LogAccessor;

final class KubernetesClientLeaderElectionInitiator {
    private static final LogAccessor LOG = new LogAccessor(KubernetesClientLeaderElectionInitiator.class);
    private final PodReadyRunner podReadyRunner;
    private final String candidateIdentity;
    private final LeaderElectionConfig leaderElectionConfig;
    private final LeaderElectionProperties leaderElectionProperties;
    private final boolean waitForPodReady;
    private final ExecutorService podReadyWaitingExecutor;
    private final BooleanSupplier podReadySupplier;
    private final KubernetesClientLeaderElectionCallbacks callbacks;
    private volatile LeaderElector leaderElector;
    private volatile CompletableFuture<Void> podReadyFuture;
    private volatile boolean shutDownCalled = false;

    KubernetesClientLeaderElectionInitiator(String candidateIdentity, String candidateNamespace, LeaderElectionConfig leaderElectionConfig, LeaderElectionProperties leaderElectionProperties, BooleanSupplier podReadySupplier, KubernetesClientLeaderElectionCallbacks callbacks) {
        this.candidateIdentity = candidateIdentity;
        this.leaderElectionConfig = leaderElectionConfig;
        this.leaderElectionProperties = leaderElectionProperties;
        this.waitForPodReady = leaderElectionProperties.waitForPodReady();
        this.podReadySupplier = podReadySupplier;
        this.callbacks = callbacks;
        this.podReadyWaitingExecutor = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "KubernetesClientLeaderElectionInitiator-" + candidateIdentity));
        this.podReadyRunner = new PodReadyRunner(candidateIdentity, candidateNamespace);
    }

    LeaderElector leaderElector() {
        return this.leaderElector;
    }

    @PostConstruct
    void postConstruct() {
        LOG.info(() -> "starting leader initiator : " + this.candidateIdentity);
        if (this.waitForPodReady) {
            LOG.info(() -> "will wait until pod " + this.candidateIdentity + " is ready");
            this.podReadyFuture = this.podReadyRunner.podReady(this.podReadySupplier);
        } else {
            this.podReadyFuture = CompletableFuture.completedFuture(null);
        }
        this.podReadyWaitingExecutor.execute(() -> {
            try {
                if (this.waitForPodReady) {
                    CompletableFuture ready = LeaderElectionInitiatorUtil.attachReadinessLoggerPipeline(this.podReadyFuture, (String)this.candidateIdentity);
                    LeaderElectionInitiatorUtil.blockReadinessCheck((CompletableFuture)ready);
                    this.startLeaderElection();
                } else {
                    this.startLeaderElection();
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e, () -> "failure : " + e.getMessage());
            }
        });
    }

    @PreDestroy
    void preDestroy() {
        LOG.info(() -> "preDestroy called on the leader initiator : " + this.candidateIdentity);
        this.shutDownCalled = true;
        if (this.podReadyFuture != null && !this.podReadyFuture.isDone()) {
            LOG.debug(() -> "podReadyFuture will be canceled for : " + this.candidateIdentity);
            this.podReadyFuture.cancel(true);
        }
        if (!this.podReadyWaitingExecutor.isShutdown()) {
            LeaderElectionInitiatorUtil.shutDownExecutor((ExecutorService)this.podReadyWaitingExecutor, (String)this.candidateIdentity);
        }
        if (this.leaderElector != null) {
            this.leaderElector.close();
        }
    }

    private void startLeaderElection() {
        LOG.info(() -> "starting leader election : " + this.candidateIdentity);
        boolean failedDuringStartup = false;
        this.leaderElector = new LeaderElector(this.leaderElectionConfig);
        try {
            this.leaderElector.run(this.callbacks.onStartLeadingCallback(), this.callbacks.onStopLeadingCallback(), this.callbacks.onNewLeaderCallback());
        }
        catch (Exception e) {
            LOG.error((Throwable)e, () -> "failure starting leader election: " + e.getMessage());
            failedDuringStartup = true;
        }
        finally {
            this.leaderElector.close();
        }
        if (this.shutDownCalled) {
            LOG.debug(() -> "leadership terminated for : " + this.candidateIdentity);
            return;
        }
        if (failedDuringStartup) {
            LOG.error(() -> "leadership failed during startup for : " + this.candidateIdentity);
            return;
        }
        LOG.debug(() -> "will re-start leader election for : " + this.candidateIdentity);
        LeaderElectionInitiatorUtil.sleep((LeaderElectionProperties)this.leaderElectionProperties);
        this.podReadyWaitingExecutor.execute(this::startLeaderElection);
    }
}

