/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.cloud.config.client.ConfigServerConfigDataLocationResolver;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesInformerDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerBootstrapper;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;

class KubernetesClientConfigServerBootstrapper
extends KubernetesConfigServerBootstrapper {
    private static final Log LOG = LogFactory.getLog(KubernetesClientConfigServerBootstrapper.class);

    KubernetesClientConfigServerBootstrapper() {
    }

    public void initialize(BootstrapRegistry registry) {
        if (KubernetesClientConfigServerBootstrapper.hasConfigServerInstanceProvider()) {
            return;
        }
        registry.registerIfAbsent(KubernetesDiscoveryProperties.class, context -> {
            if (!KubernetesClientConfigServerBootstrapper.getDiscoveryEnabled((BootstrapContext)context).booleanValue()) {
                return null;
            }
            return KubernetesClientConfigServerBootstrapper.createKubernetesDiscoveryProperties((BootstrapContext)context);
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, context -> {
            if (!KubernetesClientConfigServerBootstrapper.getDiscoveryEnabled((BootstrapContext)context).booleanValue()) {
                return id -> Collections.emptyList();
            }
            if (context.isRegistered(KubernetesInformerDiscoveryClient.class)) {
                KubernetesInformerDiscoveryClient client = (KubernetesInformerDiscoveryClient)context.get(KubernetesInformerDiscoveryClient.class);
                return client::getInstances;
            }
            ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = KubernetesClientConfigServerBootstrapper.getPropertyResolver((BootstrapContext)context);
            ApiClient defaultApiClient = KubernetesClientUtils.kubernetesApiClient();
            defaultApiClient.setUserAgent((String)propertyResolver.get("spring.cloud.kubernetes.client.user-agent", String.class, (Object)"Spring-Cloud-Kubernetes-Application"));
            KubernetesClientAutoConfiguration clientAutoConfiguration = new KubernetesClientAutoConfiguration();
            ApiClient apiClient = (ApiClient)context.getOrElseSupply(ApiClient.class, () -> defaultApiClient);
            KubernetesNamespaceProvider kubernetesNamespaceProvider = clientAutoConfiguration.kubernetesNamespaceProvider(this.getNamespaceEnvironment(propertyResolver));
            KubernetesDiscoveryProperties discoveryProperties = (KubernetesDiscoveryProperties)context.get(KubernetesDiscoveryProperties.class);
            String namespace = this.getInformerNamespace(kubernetesNamespaceProvider, discoveryProperties);
            SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(apiClient);
            GenericKubernetesApi servicesApi = new GenericKubernetesApi(V1Service.class, V1ServiceList.class, "", "v1", "services", apiClient);
            SharedIndexInformer serviceSharedIndexInformer = sharedInformerFactory.sharedIndexInformerFor(servicesApi, V1Service.class, 0L, namespace);
            Lister serviceLister = new Lister(serviceSharedIndexInformer.getIndexer());
            GenericKubernetesApi endpointsApi = new GenericKubernetesApi(V1Endpoints.class, V1EndpointsList.class, "", "v1", "endpoints", apiClient);
            SharedIndexInformer endpointsSharedIndexInformer = sharedInformerFactory.sharedIndexInformerFor(endpointsApi, V1Endpoints.class, 0L, namespace);
            Lister endpointsLister = new Lister(endpointsSharedIndexInformer.getIndexer());
            KubernetesInformerDiscoveryClient discoveryClient = new KubernetesInformerDiscoveryClient(sharedInformerFactory, (Lister<V1Service>)serviceLister, (Lister<V1Endpoints>)endpointsLister, (SharedInformer<V1Service>)serviceSharedIndexInformer, (SharedInformer<V1Endpoints>)endpointsSharedIndexInformer, discoveryProperties);
            try {
                discoveryClient.afterPropertiesSet();
                ConfigServerInstanceProvider.Function function = discoveryClient::getInstances;
                return function;
            }
            catch (Exception e) {
                LOG.warn((Object)"Error initiating informer discovery client", (Throwable)e);
                ConfigServerInstanceProvider.Function function = serviceId -> Collections.emptyList();
                return function;
            }
            finally {
                sharedInformerFactory.stopAllRegisteredInformers();
            }
        });
    }

    private String getInformerNamespace(KubernetesNamespaceProvider kubernetesNamespaceProvider, KubernetesDiscoveryProperties discoveryProperties) {
        return discoveryProperties.allNamespaces() ? "" : (kubernetesNamespaceProvider.getNamespace() == null ? "default" : kubernetesNamespaceProvider.getNamespace());
    }

    private Environment getNamespaceEnvironment(final ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver) {
        return new AbstractEnvironment(){

            public String getProperty(String key) {
                return (String)propertyResolver.get(key, String.class, (Object)super.getProperty(key));
            }
        };
    }
}

