/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.ConditionalOnBlockingOrReactiveEnabled;
import org.springframework.cloud.kubernetes.client.discovery.ConditionalOnSelectiveNamespacesPresent;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnKubernetesDiscoveryEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnKubernetesDiscoveryEnabled
@ConditionalOnBlockingOrReactiveEnabled
@Conditional(value={ConditionalOnSelectiveNamespacesPresent.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={KubernetesClientAutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class})
public class KubernetesClientInformerSelectiveNamespacesAutoConfiguration {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientInformerSelectiveNamespacesAutoConfiguration.class));

    @Bean
    @ConditionalOnMissingBean
    public List<String> selectiveNamespaces(KubernetesDiscoveryProperties properties) {
        List<String> selectiveNamespaces = properties.namespaces().stream().sorted().toList();
        LOG.debug(() -> "using selective namespaces : " + selectiveNamespaces);
        return selectiveNamespaces;
    }

    @Bean
    @ConditionalOnMissingBean(value={SharedInformerFactory.class}, parameterizedContainer={List.class})
    public List<SharedInformerFactory> sharedInformerFactories(ApiClient apiClient, List<String> selectiveNamespaces) {
        int howManyNamespaces = selectiveNamespaces.size();
        ArrayList<SharedInformerFactory> sharedInformerFactories = new ArrayList<SharedInformerFactory>(howManyNamespaces);
        for (int i = 0; i < howManyNamespaces; ++i) {
            sharedInformerFactories.add(new SharedInformerFactory(apiClient));
        }
        return sharedInformerFactories;
    }

    @Bean
    @ConditionalOnMissingBean(value={V1Service.class}, parameterizedContainer={List.class, SharedIndexInformer.class})
    public List<SharedIndexInformer<V1Service>> serviceSharedIndexInformers(List<SharedInformerFactory> sharedInformerFactories, List<String> selectiveNamespaces, ApiClient apiClient) {
        int howManyNamespaces = selectiveNamespaces.size();
        ArrayList<SharedIndexInformer<V1Service>> serviceSharedIndexedInformers = new ArrayList<SharedIndexInformer<V1Service>>(howManyNamespaces);
        for (int i = 0; i < howManyNamespaces; ++i) {
            GenericKubernetesApi servicesApi = new GenericKubernetesApi(V1Service.class, V1ServiceList.class, "", "v1", "services", apiClient);
            SharedIndexInformer sharedIndexInformer = sharedInformerFactories.get(i).sharedIndexInformerFor(servicesApi, V1Service.class, 0L, selectiveNamespaces.get(i));
            serviceSharedIndexedInformers.add((SharedIndexInformer<V1Service>)sharedIndexInformer);
        }
        return serviceSharedIndexedInformers;
    }

    @Bean
    @ConditionalOnMissingBean(value={V1Service.class}, parameterizedContainer={List.class, Lister.class})
    public List<Lister<V1Service>> serviceListers(List<String> selectiveNamespaces, List<SharedIndexInformer<V1Service>> serviceSharedIndexInformers) {
        int howManyNamespaces = selectiveNamespaces.size();
        ArrayList<Lister<V1Service>> serviceListers = new ArrayList<Lister<V1Service>>(howManyNamespaces);
        for (int i = 0; i < howManyNamespaces; ++i) {
            String namespace = selectiveNamespaces.get(i);
            Lister lister = new Lister(serviceSharedIndexInformers.get(i).getIndexer(), namespace);
            LOG.debug(() -> "registering lister (for services) in namespace : " + namespace);
            serviceListers.add((Lister<V1Service>)lister);
        }
        return serviceListers;
    }

    @Bean
    @ConditionalOnMissingBean(value={V1Endpoints.class}, parameterizedContainer={List.class, SharedIndexInformer.class})
    public List<SharedIndexInformer<V1Endpoints>> endpointsSharedIndexInformers(List<SharedInformerFactory> sharedInformerFactories, List<String> selectiveNamespaces, ApiClient apiClient) {
        int howManyNamespaces = selectiveNamespaces.size();
        ArrayList<SharedIndexInformer<V1Endpoints>> endpointsSharedIndexedInformers = new ArrayList<SharedIndexInformer<V1Endpoints>>(howManyNamespaces);
        for (int i = 0; i < howManyNamespaces; ++i) {
            GenericKubernetesApi endpointsApi = new GenericKubernetesApi(V1Endpoints.class, V1EndpointsList.class, "", "v1", "endpoints", apiClient);
            SharedIndexInformer sharedIndexInformer = sharedInformerFactories.get(i).sharedIndexInformerFor(endpointsApi, V1Endpoints.class, 0L, selectiveNamespaces.get(i));
            endpointsSharedIndexedInformers.add((SharedIndexInformer<V1Endpoints>)sharedIndexInformer);
        }
        return endpointsSharedIndexedInformers;
    }

    @Bean
    @ConditionalOnMissingBean(value={V1Endpoints.class}, parameterizedContainer={List.class, Lister.class})
    public List<Lister<V1Endpoints>> endpointsListers(List<String> selectiveNamespaces, List<SharedIndexInformer<V1Endpoints>> serviceSharedIndexInformers) {
        int howManyNamespaces = selectiveNamespaces.size();
        ArrayList<Lister<V1Endpoints>> endpointsListers = new ArrayList<Lister<V1Endpoints>>(howManyNamespaces);
        for (int i = 0; i < howManyNamespaces; ++i) {
            String namespace = selectiveNamespaces.get(i);
            Lister lister = new Lister(serviceSharedIndexInformers.get(i).getIndexer());
            LOG.debug(() -> "registering lister (for endpoints) in namespace : " + namespace);
            endpointsListers.add((Lister<V1Endpoints>)lister);
        }
        return endpointsListers;
    }
}

