/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.spring.extended.controller.annotation.GroupVersionResource;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformer;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformers;
import io.kubernetes.client.spring.extended.controller.config.KubernetesInformerAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesInformerDiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.SpringCloudKubernetesInformerFactoryProcessor;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnKubernetesDiscoveryEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesDiscoveryEnabled
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class, KubernetesInformerAutoConfiguration.class})
@AutoConfigureAfter(value={KubernetesClientAutoConfiguration.class})
@EnableConfigurationProperties(value={KubernetesDiscoveryProperties.class})
public class KubernetesDiscoveryClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    public static class KubernetesInformerDiscoveryConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SpringCloudKubernetesInformerFactoryProcessor discoveryInformerConfigurer(KubernetesNamespaceProvider kubernetesNamespaceProvider, ApiClient apiClient, CatalogSharedInformerFactory sharedInformerFactory, Environment environment) {
            boolean allNamespaces = (Boolean)environment.getProperty("spring.cloud.kubernetes.discovery.all-namespaces", Boolean.class, (Object)false);
            return new SpringCloudKubernetesInformerFactoryProcessor(kubernetesNamespaceProvider, apiClient, sharedInformerFactory, allNamespaces);
        }

        @Bean
        @ConditionalOnMissingBean
        public CatalogSharedInformerFactory catalogSharedInformerFactory(ApiClient apiClient) {
            return new CatalogSharedInformerFactory();
        }

        @Bean
        @ConditionalOnMissingBean
        public KubernetesInformerDiscoveryClient kubernetesInformerDiscoveryClient(KubernetesNamespaceProvider kubernetesNamespaceProvider, CatalogSharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
            return new KubernetesInformerDiscoveryClient(kubernetesNamespaceProvider.getNamespace(), sharedInformerFactory, serviceLister, endpointsLister, serviceInformer, endpointsInformer, properties);
        }

        @KubernetesInformers(value={@KubernetesInformer(apiTypeClass=V1Service.class, apiListTypeClass=V1ServiceList.class, groupVersionResource=@GroupVersionResource(apiGroup="", apiVersion="v1", resourcePlural="services")), @KubernetesInformer(apiTypeClass=V1Endpoints.class, apiListTypeClass=V1EndpointsList.class, groupVersionResource=@GroupVersionResource(apiGroup="", apiVersion="v1", resourcePlural="endpoints"))})
        class CatalogSharedInformerFactory
        extends SharedInformerFactory {
            CatalogSharedInformerFactory() {
            }
        }
    }

    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnDiscoveryEnabled
    @ConditionalOnDiscoveryHealthIndicatorEnabled
    @Configuration
    public static class KubernetesDiscoveryClientHealthIndicatorConfiguration {
        @Bean
        public KubernetesDiscoveryClientHealthIndicatorInitializer indicatorInitializer(ApplicationEventPublisher applicationEventPublisher, PodUtils podUtils) {
            return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
        }
    }
}

