/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config.reload;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadUtil;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.log.LogAccessor;

public class KubernetesClientEventBasedConfigMapChangeDetector
extends ConfigurationChangeDetector {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientEventBasedConfigMapChangeDetector.class));
    private final CoreV1Api coreV1Api;
    private final KubernetesClientConfigMapPropertySourceLocator propertySourceLocator;
    private final ApiClient apiClient;
    private final List<SharedIndexInformer<V1ConfigMap>> informers = new ArrayList<SharedIndexInformer<V1ConfigMap>>();
    private final List<SharedInformerFactory> factories = new ArrayList<SharedInformerFactory>();
    private final Set<String> namespaces;
    private final boolean enableReloadFiltering;
    private final ResourceEventHandler<V1ConfigMap> handler = new ResourceEventHandler<V1ConfigMap>(){

        public void onAdd(V1ConfigMap configMap) {
            LOG.debug(() -> "ConfigMap " + configMap.getMetadata().getName() + " was added in namespace " + configMap.getMetadata().getNamespace());
            KubernetesClientEventBasedConfigMapChangeDetector.this.onEvent((KubernetesObject)configMap);
        }

        public void onUpdate(V1ConfigMap oldConfigMap, V1ConfigMap newConfigMap) {
            LOG.debug(() -> "ConfigMap " + newConfigMap.getMetadata().getName() + " was updated in namespace " + newConfigMap.getMetadata().getNamespace());
            KubernetesClientEventBasedConfigMapChangeDetector.this.onEvent((KubernetesObject)newConfigMap);
        }

        public void onDelete(V1ConfigMap configMap, boolean deletedFinalStateUnknown) {
            LOG.debug(() -> "ConfigMap " + configMap.getMetadata().getName() + " was deleted in namespace " + configMap.getMetadata().getNamespace());
            KubernetesClientEventBasedConfigMapChangeDetector.this.onEvent((KubernetesObject)configMap);
        }
    };

    public KubernetesClientEventBasedConfigMapChangeDetector(CoreV1Api coreV1Api, ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientConfigMapPropertySourceLocator propertySourceLocator, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        super(environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.coreV1Api = coreV1Api;
        this.apiClient = KubernetesClientUtils.createApiClientForInformerClient();
        this.enableReloadFiltering = properties.enableReloadFiltering();
        this.namespaces = KubernetesClientConfigUtils.namespaces(kubernetesNamespaceProvider, properties, "configmap");
    }

    @PostConstruct
    void inform() {
        LOG.info(() -> "Kubernetes event-based configMap change detector activated");
        this.namespaces.forEach(namespace -> {
            String[] filter = new String[1];
            if (this.enableReloadFiltering) {
                filter[0] = "spring.cloud.kubernetes.config.informer.enabled=true";
            }
            SharedInformerFactory factory = new SharedInformerFactory(this.apiClient);
            this.factories.add(factory);
            SharedIndexInformer informer = factory.sharedIndexInformerFor(params -> this.coreV1Api.listNamespacedConfigMapCall(namespace, null, null, null, null, filter[0], null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1ConfigMap.class, V1ConfigMapList.class);
            LOG.debug(() -> "added configmap informer for namespace : " + namespace + " with filter : " + filter[0]);
            informer.addEventHandler(this.handler);
            this.informers.add((SharedIndexInformer<V1ConfigMap>)informer);
            factory.startAllRegisteredInformers();
        });
    }

    @PreDestroy
    void shutdown() {
        this.informers.forEach(SharedInformer::stop);
        this.factories.forEach(SharedInformerFactory::stopAllRegisteredInformers);
    }

    protected void onEvent(KubernetesObject configMap) {
        boolean reload = ConfigReloadUtil.reload((String)"config-map", (String)configMap.toString(), (PropertySourceLocator)this.propertySourceLocator, (ConfigurableEnvironment)this.environment, KubernetesClientConfigMapPropertySource.class);
        if (reload) {
            this.reloadProperties();
        }
    }
}

