/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigContext;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySource;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class KubernetesClientSecretsPropertySourceLocator
extends SecretsPropertySourceLocator {
    private final CoreV1Api coreV1Api;
    private final KubernetesNamespaceProvider kubernetesNamespaceProvider;

    public KubernetesClientSecretsPropertySourceLocator(CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider, SecretsConfigProperties secretsConfigProperties) {
        super(secretsConfigProperties);
        this.coreV1Api = coreV1Api;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
    }

    protected MapPropertySource getPropertySource(ConfigurableEnvironment environment, NormalizedSource source) {
        String normalizedNamespace = source.namespace().orElse(null);
        String namespace = KubernetesClientUtils.getApplicationNamespace((String)normalizedNamespace, (String)source.target(), (KubernetesNamespaceProvider)this.kubernetesNamespaceProvider);
        KubernetesClientConfigContext context = new KubernetesClientConfigContext(this.coreV1Api, source, namespace, (Environment)environment);
        return new KubernetesClientSecretsPropertySource(context);
    }
}

