/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class KubernetesClientConfigMapPropertySourceLocator
extends ConfigMapPropertySourceLocator {
    private CoreV1Api coreV1Api;
    private KubernetesClientProperties kubernetesClientProperties;

    public KubernetesClientConfigMapPropertySourceLocator(CoreV1Api coreV1Api, ConfigMapConfigProperties properties, KubernetesClientProperties kubernetesClientProperties) {
        super(properties);
        this.coreV1Api = coreV1Api;
        this.kubernetesClientProperties = kubernetesClientProperties;
    }

    protected MapPropertySource getMapPropertySource(String name, ConfigMapConfigProperties.NormalizedSource normalizedSource, String configurationTarget, ConfigurableEnvironment environment) {
        return new KubernetesClientConfigMapPropertySource(this.coreV1Api, name, KubernetesClientConfigUtils.getNamespace(normalizedSource, this.kubernetesClientProperties), (Environment)environment);
    }
}

