/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.EnvReader;
import org.springframework.cloud.kubernetes.commons.LazilyInstantiate;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.util.StringUtils;

public class KubernetesClientPodUtils
implements PodUtils<V1Pod> {
    public static final String HOSTNAME = "HOSTNAME";
    public static final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private static final Log LOG = LogFactory.getLog(KubernetesClientPodUtils.class);
    private final CoreV1Api client;
    private final String hostName;
    private final Supplier<V1Pod> current;
    private final String namespace;
    private final String serviceHost;

    public KubernetesClientPodUtils(CoreV1Api client, String namespace) {
        if (client == null) {
            throw new IllegalArgumentException("Must provide an instance of KubernetesClient");
        }
        this.client = client;
        this.hostName = EnvReader.getEnv((String)HOSTNAME);
        this.serviceHost = EnvReader.getEnv((String)KUBERNETES_SERVICE_HOST);
        this.current = LazilyInstantiate.using(this::internalGetPod);
        this.namespace = namespace;
    }

    public Supplier<V1Pod> currentPod() {
        return this.current;
    }

    public Boolean isInsideKubernetes() {
        return this.currentPod().get() != null;
    }

    private V1Pod internalGetPod() {
        try {
            if (this.isServiceHostEnvVarPresent() && this.isHostNameEnvVarPresent() && this.isServiceAccountFound()) {
                return this.client.readNamespacedPod(this.hostName, this.namespace, null, null, null);
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to get pod with name:[" + this.hostName + "]. You should look into this if things aren't" + " working as you expect. Are you missing serviceaccount permissions?"), t);
        }
        return null;
    }

    private boolean isServiceHostEnvVarPresent() {
        return StringUtils.hasLength((String)this.serviceHost);
    }

    private boolean isHostNameEnvVarPresent() {
        return StringUtils.hasLength((String)this.hostName);
    }

    private boolean isServiceAccountFound() {
        boolean serviceAccountPathPresent = Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]).toFile().exists();
        if (!serviceAccountPathPresent) {
            LOG.warn((Object)"serviceaccount path not present, did you disable it via 'automountServiceAccountToken : false'? Major functionalities will not work without that property being set");
        }
        return serviceAccountPathPresent && Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0]).toFile().exists();
    }
}

