/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.secretmanager;

import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.secretmanager.v1beta1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1beta1.AddSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta1.CreateSecretRequest;
import com.google.cloud.secretmanager.v1beta1.DeleteSecretRequest;
import com.google.cloud.secretmanager.v1beta1.ProjectName;
import com.google.cloud.secretmanager.v1beta1.Replication;
import com.google.cloud.secretmanager.v1beta1.Secret;
import com.google.cloud.secretmanager.v1beta1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1beta1.SecretName;
import com.google.cloud.secretmanager.v1beta1.SecretPayload;
import com.google.cloud.secretmanager.v1beta1.SecretVersionName;
import com.google.protobuf.ByteString;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.secretmanager.SecretManagerOperations;
import org.springframework.cloud.gcp.secretmanager.SecretManagerPropertyUtils;

public class SecretManagerTemplate
implements SecretManagerOperations {
    public static final String LATEST_VERSION = "latest";
    private final SecretManagerServiceClient secretManagerServiceClient;
    private final GcpProjectIdProvider projectIdProvider;

    public SecretManagerTemplate(SecretManagerServiceClient secretManagerServiceClient, GcpProjectIdProvider projectIdProvider) {
        this.secretManagerServiceClient = secretManagerServiceClient;
        this.projectIdProvider = projectIdProvider;
    }

    @Override
    public void createSecret(String secretId, String payload) {
        this.createNewSecretVersion(secretId, ByteString.copyFromUtf8((String)payload), this.projectIdProvider.getProjectId());
    }

    @Override
    public void createSecret(String secretId, byte[] payload) {
        this.createNewSecretVersion(secretId, ByteString.copyFrom((byte[])payload), this.projectIdProvider.getProjectId());
    }

    @Override
    public void createSecret(String secretId, byte[] payload, String projectId) {
        this.createNewSecretVersion(secretId, ByteString.copyFrom((byte[])payload), projectId);
    }

    @Override
    public String getSecretString(String secretIdentifier) {
        return this.getSecretByteString(secretIdentifier).toStringUtf8();
    }

    @Override
    public byte[] getSecretBytes(String secretIdentifier) {
        return this.getSecretByteString(secretIdentifier).toByteArray();
    }

    @Override
    public boolean secretExists(String secretId) {
        return this.secretExists(secretId, this.projectIdProvider.getProjectId());
    }

    @Override
    public boolean secretExists(String secretId, String projectId) {
        SecretName secretName = SecretName.of((String)projectId, (String)secretId);
        try {
            this.secretManagerServiceClient.getSecret(secretName);
        }
        catch (NotFoundException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void disableSecretVersion(String secretId, String version) {
        this.disableSecretVersion(secretId, version, this.projectIdProvider.getProjectId());
    }

    @Override
    public void disableSecretVersion(String secretId, String version, String projectId) {
        SecretVersionName secretVersionName = SecretVersionName.newBuilder().setProject(projectId).setSecret(secretId).setSecretVersion(version).build();
        this.secretManagerServiceClient.disableSecretVersion(secretVersionName);
    }

    @Override
    public void enableSecretVersion(String secretId, String version) {
        this.enableSecretVersion(secretId, version, this.projectIdProvider.getProjectId());
    }

    @Override
    public void enableSecretVersion(String secretId, String version, String projectId) {
        SecretVersionName secretVersionName = SecretVersionName.newBuilder().setProject(projectId).setSecret(secretId).setSecretVersion(version).build();
        this.secretManagerServiceClient.enableSecretVersion(secretVersionName);
    }

    @Override
    public void deleteSecret(String secretId) {
        this.deleteSecret(secretId, this.projectIdProvider.getProjectId());
    }

    @Override
    public void deleteSecret(String secretId, String projectId) {
        SecretName name = SecretName.of((String)projectId, (String)secretId);
        DeleteSecretRequest request = DeleteSecretRequest.newBuilder().setName(name.toString()).build();
        this.secretManagerServiceClient.deleteSecret(request);
    }

    @Override
    public void deleteSecretVersion(String secretId, String version, String projectId) {
        SecretVersionName secretVersionName = SecretVersionName.newBuilder().setProject(projectId).setSecret(secretId).setSecretVersion(version).build();
        this.secretManagerServiceClient.destroySecretVersion(secretVersionName);
    }

    ByteString getSecretByteString(String secretIdentifier) {
        SecretVersionName secretVersionName = SecretManagerPropertyUtils.getSecretVersionName(secretIdentifier, this.projectIdProvider);
        if (secretVersionName == null) {
            secretVersionName = this.getDefaultSecretVersionName(secretIdentifier);
        }
        return this.getSecretByteString(secretVersionName);
    }

    ByteString getSecretByteString(SecretVersionName secretVersionName) {
        AccessSecretVersionResponse response = this.secretManagerServiceClient.accessSecretVersion(secretVersionName);
        return response.getPayload().getData();
    }

    private void createNewSecretVersion(String secretId, ByteString payload, String projectId) {
        if (!this.secretExists(secretId, projectId)) {
            this.createSecretInternal(secretId, projectId);
        }
        SecretName name = SecretName.of((String)projectId, (String)secretId);
        AddSecretVersionRequest payloadRequest = AddSecretVersionRequest.newBuilder().setParent(name.toString()).setPayload(SecretPayload.newBuilder().setData(payload)).build();
        this.secretManagerServiceClient.addSecretVersion(payloadRequest);
    }

    private void createSecretInternal(String secretId, String projectId) {
        ProjectName projectName = ProjectName.of((String)projectId);
        Secret secret = Secret.newBuilder().setReplication(Replication.newBuilder().setAutomatic(Replication.Automatic.getDefaultInstance())).build();
        CreateSecretRequest request = CreateSecretRequest.newBuilder().setParent(projectName.toString()).setSecretId(secretId).setSecret(secret).build();
        this.secretManagerServiceClient.createSecret(request);
    }

    private SecretVersionName getDefaultSecretVersionName(String secretId) {
        return SecretVersionName.newBuilder().setProject(this.projectIdProvider.getProjectId()).setSecret(secretId).setSecretVersion(LATEST_VERSION).build();
    }
}

