/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.secretmanager;

import com.google.cloud.secretmanager.v1beta1.SecretVersionName;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.util.Assert;

final class SecretManagerPropertyUtils {
    private static final String GCP_SECRET_PREFIX = "sm://";

    private SecretManagerPropertyUtils() {
    }

    static SecretVersionName getSecretVersionName(String input, GcpProjectIdProvider projectIdProvider) {
        if (!input.startsWith(GCP_SECRET_PREFIX)) {
            return null;
        }
        String resourcePath = input.substring(GCP_SECRET_PREFIX.length());
        String[] tokens = resourcePath.split("/");
        String projectId = projectIdProvider.getProjectId();
        String secretId = null;
        String version = "latest";
        if (tokens.length == 1) {
            secretId = tokens[0];
        } else if (tokens.length == 2) {
            secretId = tokens[0];
            version = tokens[1];
        } else if (tokens.length == 3) {
            projectId = tokens[0];
            secretId = tokens[1];
            version = tokens[2];
        } else if (tokens.length == 4 && tokens[0].equals("projects") && tokens[2].equals("secrets")) {
            projectId = tokens[1];
            secretId = tokens[3];
        } else if (tokens.length == 6 && tokens[0].equals("projects") && tokens[2].equals("secrets") && tokens[4].equals("versions")) {
            projectId = tokens[1];
            secretId = tokens[3];
            version = tokens[5];
        } else {
            throw new IllegalArgumentException("Unrecognized format for specifying a GCP Secret Manager secret: " + input);
        }
        Assert.hasText((String)secretId, (String)("The GCP Secret Manager secret id must not be empty: " + input));
        Assert.hasText((String)projectId, (String)("The GCP Secret Manager project id must not be empty: " + input));
        Assert.hasText((String)version, (String)("The GCP Secret Manager secret version must not be empty: " + input));
        return SecretVersionName.newBuilder().setProject(projectId).setSecret(secretId).setSecretVersion(version).build();
    }
}

