/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.secretmanager;

import com.google.cloud.secretmanager.v1beta1.SecretVersionName;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.secretmanager.SecretManagerPropertyUtils;
import org.springframework.cloud.gcp.secretmanager.SecretManagerTemplate;
import org.springframework.core.env.EnumerablePropertySource;

public class SecretManagerPropertySource
extends EnumerablePropertySource<SecretManagerTemplate> {
    private final GcpProjectIdProvider projectIdProvider;

    public SecretManagerPropertySource(String propertySourceName, SecretManagerTemplate secretManagerTemplate, GcpProjectIdProvider projectIdProvider) {
        super(propertySourceName, (Object)secretManagerTemplate);
        this.projectIdProvider = projectIdProvider;
    }

    public Object getProperty(String name) {
        SecretVersionName secretIdentifier = SecretManagerPropertyUtils.getSecretVersionName(name, this.projectIdProvider);
        if (secretIdentifier != null) {
            return ((SecretManagerTemplate)this.getSource()).getSecretByteString(secretIdentifier);
        }
        return null;
    }

    public String[] getPropertyNames() {
        return new String[0];
    }
}

