/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.stream.binder.pubsub.config;

import com.google.common.collect.ImmutableMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.cloud.gcp.pubsub.PubSubAdmin;
import org.springframework.cloud.gcp.pubsub.core.PubSubTemplate;
import org.springframework.cloud.gcp.stream.binder.pubsub.PubSubMessageChannelBinder;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubExtendedBindingProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.provisioning.PubSubChannelProvisioner;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.config.BindingHandlerAdvise;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@EnableConfigurationProperties(value={PubSubExtendedBindingProperties.class})
public class PubSubBinderConfiguration {
    @Bean
    public PubSubChannelProvisioner pubSubChannelProvisioner(PubSubAdmin pubSubAdmin) {
        return new PubSubChannelProvisioner(pubSubAdmin);
    }

    @Bean
    public PubSubMessageChannelBinder pubSubBinder(PubSubChannelProvisioner pubSubChannelProvisioner, PubSubTemplate pubSubTemplate, PubSubExtendedBindingProperties pubSubExtendedBindingProperties) {
        return new PubSubMessageChannelBinder(null, pubSubChannelProvisioner, pubSubTemplate, pubSubExtendedBindingProperties);
    }

    @Bean
    public BindingHandlerAdvise.MappingsProvider pubSubExtendedPropertiesDefaultMappingsProvider() {
        return () -> ImmutableMap.of((Object)ConfigurationPropertyName.of((CharSequence)"spring.cloud.stream.gcp.pubsub.bindings"), (Object)ConfigurationPropertyName.of((CharSequence)"spring.cloud.stream.gcp.pubsub.default"));
    }
}

