/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.stream.binder.pubsub;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.gcp.pubsub.core.PubSubOperations;
import org.springframework.cloud.gcp.pubsub.core.PubSubTemplate;
import org.springframework.cloud.gcp.pubsub.integration.inbound.PubSubInboundChannelAdapter;
import org.springframework.cloud.gcp.pubsub.integration.outbound.PubSubMessageHandler;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubConsumerProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubExtendedBindingProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubProducerProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.provisioning.PubSubChannelProvisioner;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.core.MessageProducer;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

public class PubSubMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<PubSubConsumerProperties>, ExtendedProducerProperties<PubSubProducerProperties>, PubSubChannelProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, PubSubConsumerProperties, PubSubProducerProperties> {
    private PubSubTemplate pubSubTemplate;
    private PubSubExtendedBindingProperties pubSubExtendedBindingProperties = new PubSubExtendedBindingProperties();

    public PubSubMessageChannelBinder(String[] headersToEmbed, PubSubChannelProvisioner provisioningProvider, PubSubTemplate pubSubTemplate) {
        super(headersToEmbed, (ProvisioningProvider)provisioningProvider);
        this.pubSubTemplate = pubSubTemplate;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<PubSubProducerProperties> producerProperties, MessageChannel errorChannel) {
        PubSubMessageHandler messageHandler = new PubSubMessageHandler((PubSubOperations)this.pubSubTemplate, destination.getName());
        messageHandler.setBeanFactory((BeanFactory)this.getBeanFactory());
        return messageHandler;
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<PubSubConsumerProperties> properties) {
        PubSubInboundChannelAdapter inboundAdapter = new PubSubInboundChannelAdapter(this.pubSubTemplate, destination.getName());
        return inboundAdapter;
    }

    public PubSubConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.pubSubExtendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public PubSubProducerProperties getExtendedProducerProperties(String channelName) {
        return this.pubSubExtendedBindingProperties.getExtendedProducerProperties(channelName);
    }
}

