/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.admin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class CachingComposingSupplier<T, U>
implements Supplier<T> {
    private final Map<U, T> products = new ConcurrentHashMap<U, T>();
    private final Supplier<U> inputProvider;
    private final Function<U, T> producer;

    public CachingComposingSupplier(Supplier<U> inputProvider, Function<U, T> producer) {
        this.inputProvider = inputProvider;
        this.producer = producer;
    }

    @Override
    public T get() {
        return this.products.computeIfAbsent(this.inputProvider.get(), this.producer);
    }
}

