/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Statement;
import java.util.Collection;
import java.util.function.Function;
import org.springframework.cloud.gcp.data.spanner.core.SpannerMutationFactory;
import org.springframework.cloud.gcp.data.spanner.core.SpannerReadOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.admin.SpannerSchemaUtils;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerEntityProcessor;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;

class ReadOnlyTransactionSpannerTemplate
extends SpannerTemplate {
    private ReadOnlyTransaction readOnlyTransaction;

    ReadOnlyTransactionSpannerTemplate(DatabaseClient databaseClient, SpannerMappingContext mappingContext, SpannerEntityProcessor spannerEntityProcessor, SpannerMutationFactory spannerMutationFactory, SpannerSchemaUtils spannerSchemaUtils, ReadOnlyTransaction readOnlyTransaction) {
        super(databaseClient, mappingContext, spannerEntityProcessor, spannerMutationFactory, spannerSchemaUtils);
        this.readOnlyTransaction = readOnlyTransaction;
    }

    @Override
    protected void applyMutations(Collection<Mutation> mutations) {
        throw new SpannerDataException("A read-only transaction template cannot perform mutations.");
    }

    @Override
    public long executeDmlStatement(Statement statement) {
        throw new SpannerDataException("A read-only transaction template cannot execute DML.");
    }

    @Override
    protected ReadContext getReadContext() {
        return this.readOnlyTransaction;
    }

    @Override
    protected ReadContext getReadContext(Timestamp timestamp) {
        throw new SpannerDataException("Getting stale snapshot read contexts is not supported in read-only transaction templates.");
    }

    @Override
    public <T> T performReadWriteTransaction(Function<SpannerTemplate, T> operations) {
        throw new SpannerDataException("A read-only transaction is already under execution. Opening sub-transactions is not supported!");
    }

    @Override
    public <T> T performReadOnlyTransaction(Function<SpannerTemplate, T> operations, SpannerReadOptions readOptions) {
        throw new SpannerDataException("A read-only transaction is already under execution. Opening sub-transactions is not supported!");
    }
}

