/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.support;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.SpannerPageableQueryOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.repository.SpannerRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class SimpleSpannerRepository<T, ID>
implements SpannerRepository<T, ID> {
    private final SpannerTemplate spannerTemplate;
    private final Class<T> entityType;

    public SimpleSpannerRepository(SpannerTemplate spannerTemplate, Class<T> entityType) {
        Assert.notNull((Object)spannerTemplate, (String)"A valid SpannerTemplate object is required.");
        Assert.notNull(entityType, (String)"A valid entity type is required.");
        this.spannerTemplate = spannerTemplate;
        this.entityType = entityType;
    }

    @Override
    public SpannerOperations getSpannerTemplate() {
        return this.spannerTemplate;
    }

    @Override
    public <A> A performReadOnlyTransaction(Function<SpannerRepository<T, ID>, A> operations) {
        return (A)this.spannerTemplate.performReadOnlyTransaction(transactionSpannerOperations -> operations.apply(new SimpleSpannerRepository<T, ID>((SpannerTemplate)transactionSpannerOperations, this.entityType)), null);
    }

    @Override
    public <A> A performReadWriteTransaction(Function<SpannerRepository<T, ID>, A> operations) {
        return (A)this.spannerTemplate.performReadWriteTransaction((SpannerTemplate transactionSpannerOperations) -> operations.apply(new SimpleSpannerRepository<T, ID>((SpannerTemplate)transactionSpannerOperations, this.entityType)));
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"A non-null entity is required for saving.");
        this.spannerTemplate.upsert(entity);
        return entity;
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"A non-null list of entities is required for saving.");
        this.spannerTemplate.upsertAll(entities);
        return entities;
    }

    public Optional<T> findById(ID key) {
        Assert.notNull(key, (String)"A non-null ID is required.");
        return this.doIfKey(key, k -> {
            T result = this.spannerTemplate.read(this.entityType, (Key)k);
            return Optional.ofNullable(result);
        });
    }

    public boolean existsById(ID key) {
        Assert.notNull(key, (String)"A non-null ID is required.");
        return this.findById(key).isPresent();
    }

    public Iterable<T> findAll() {
        return this.spannerTemplate.readAll(this.entityType);
    }

    public Iterable<T> findAllById(Iterable<ID> iterable) {
        KeySet.Builder builder = KeySet.newBuilder();
        for (ID id : iterable) {
            this.doIfKey(id, arg_0 -> ((KeySet.Builder)builder).addKey(arg_0));
        }
        return this.spannerTemplate.read(this.entityType, builder.build());
    }

    public long count() {
        return this.spannerTemplate.count(this.entityType);
    }

    public void deleteById(Object key) {
        Assert.notNull((Object)key, (String)"A non-null ID is required.");
        this.doIfKey(key, k -> {
            this.spannerTemplate.delete((Class)this.entityType, (Key)k);
            return null;
        });
    }

    public void delete(Object entity) {
        Assert.notNull((Object)entity, (String)"A non-null entity is required.");
        this.spannerTemplate.delete(entity);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"A non-null list of entities is required.");
        this.spannerTemplate.deleteAll(entities);
    }

    public void deleteAll() {
        this.spannerTemplate.delete(this.entityType, KeySet.all());
    }

    public Iterable<T> findAll(Sort sort) {
        return this.spannerTemplate.queryAll(this.entityType, new SpannerPageableQueryOptions().setSort(sort));
    }

    public Page<T> findAll(Pageable pageable) {
        return new PageImpl(this.spannerTemplate.queryAll(this.entityType, new SpannerPageableQueryOptions().setLimit(pageable.getPageSize()).setOffset(pageable.getOffset()).setSort(pageable.getSort())), pageable, this.spannerTemplate.count(this.entityType));
    }

    private <A> A doIfKey(Object key, Function<Key, A> operation) {
        Key k = this.spannerTemplate.getSpannerEntityProcessor().convertToKey(key);
        return operation.apply(k);
    }
}

