/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerCustomConverter;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    static Class boxIfNeeded(Class propertyType) {
        if (propertyType == null) {
            return null;
        }
        return propertyType.isPrimitive() ? Array.get(Array.newInstance(propertyType, 1), 0).getClass() : propertyType;
    }

    public static boolean isIterableNonByteArrayType(Class propType) {
        return Iterable.class.isAssignableFrom(propType) && !ByteArray.class.isAssignableFrom(propType);
    }

    static <T> Iterable<T> convertIterable(Iterable<Object> source, Class<T> targetType, SpannerCustomConverter converter) {
        ArrayList result = new ArrayList();
        source.forEach(item -> result.add(converter.convert(item, targetType)));
        return result;
    }
}

