/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.storage;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpProperties;
import org.springframework.cloud.gcp.autoconfigure.storage.GcpStorageProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UserAgentHeaderProvider;
import org.springframework.cloud.gcp.storage.GoogleStorageProtocolResolver;
import org.springframework.cloud.gcp.storage.GoogleStorageProtocolResolverSettings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={GoogleStorageProtocolResolverSettings.class, Storage.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.storage.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GcpProperties.class, GcpStorageProperties.class})
@Import(value={GoogleStorageProtocolResolver.class})
public abstract class GcpStorageAutoConfiguration {
    private final GcpProjectIdProvider gcpProjectIdProvider;
    private final CredentialsProvider credentialsProvider;

    public GcpStorageAutoConfiguration(GcpProjectIdProvider coreProjectIdProvider, CredentialsProvider credentialsProvider, GcpStorageProperties gcpStorageProperties) throws IOException {
        this.gcpProjectIdProvider = gcpStorageProperties.getProjectId() != null ? gcpStorageProperties::getProjectId : coreProjectIdProvider;
        this.credentialsProvider = gcpStorageProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpStorageProperties) : credentialsProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public Storage storage() throws IOException {
        return (Storage)((StorageOptions.Builder)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpStorageAutoConfiguration.class))).setProjectId(this.gcpProjectIdProvider.getProjectId())).setCredentials(this.credentialsProvider.getCredentials())).build().getService();
    }
}

