/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.spanner;

import com.google.cloud.spanner.Key;
import java.io.Serializable;
import java.util.StringJoiner;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;

public class SpannerKeyIdConverter
implements BackendIdConverter {
    private SpannerMappingContext mappingContext;

    public SpannerKeyIdConverter(SpannerMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    public Serializable fromRequestId(String id, Class<?> entityType) {
        if (id == null) {
            return null;
        }
        Object[] parts = id.split(this.getUrlIdSeparator());
        return Key.of((Object[])parts);
    }

    protected String getUrlIdSeparator() {
        return ",";
    }

    public String toRequestId(Serializable source, Class<?> entityType) {
        Key id = (Key)source;
        StringJoiner stringJoiner = new StringJoiner(this.getUrlIdSeparator());
        id.getParts().forEach(p -> stringJoiner.add(p.toString()));
        return stringJoiner.toString();
    }

    public boolean supports(Class<?> type) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(type);
        return persistentEntity != null && persistentEntity.getIdProperty() != null && persistentEntity.getIdProperty().getActualType().equals(Key.class);
    }
}

