/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.logging;

import com.google.cloud.logging.logback.LoggingAppender;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.gcp.autoconfigure.logging.LoggingWebMvcConfigurer;
import org.springframework.cloud.gcp.autoconfigure.logging.TraceIdLoggingWebMvcInterceptor;
import org.springframework.cloud.gcp.autoconfigure.logging.extractors.TraceIdExtractor;
import org.springframework.cloud.gcp.autoconfigure.logging.extractors.XCloudTraceIdExtractor;
import org.springframework.cloud.gcp.autoconfigure.trace.StackdriverTraceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@ConditionalOnClass(value={HandlerInterceptorAdapter.class, LoggingAppender.class})
@ConditionalOnMissingBean(type={"org.springframework.cloud.sleuth.autoconfig.SleuthProperties"})
@AutoConfigureAfter(value={StackdriverTraceAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(value={"spring.cloud.gcp.logging.enabled"}, matchIfMissing=true)
@Import(value={LoggingWebMvcConfigurer.class})
public class StackdriverLoggingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TraceIdLoggingWebMvcInterceptor loggingWebMvcInterceptor(TraceIdExtractor extractor) {
        return new TraceIdLoggingWebMvcInterceptor(extractor);
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceIdExtractor traceIdExtractor() {
        return new XCloudTraceIdExtractor();
    }
}

