/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.trace;

import brave.http.HttpClientParser;
import brave.http.HttpServerParser;
import brave.propagation.Propagation;
import brave.sampler.Sampler;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import io.grpc.CallOptions;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.gcp.autoconfigure.trace.GcpTraceProperties;
import org.springframework.cloud.gcp.autoconfigure.trace.sleuth.StackdriverHttpClientParser;
import org.springframework.cloud.gcp.autoconfigure.trace.sleuth.StackdriverHttpServerParser;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UsageTrackingHeaderProvider;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.TraceHttpAutoConfiguration;
import org.springframework.cloud.sleuth.sampler.ProbabilityBasedSampler;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.propagation.stackdriver.StackdriverTracePropagation;
import zipkin2.reporter.Sender;
import zipkin2.reporter.stackdriver.StackdriverEncoder;
import zipkin2.reporter.stackdriver.StackdriverSender;

@Configuration
@EnableConfigurationProperties(value={SamplerProperties.class, GcpTraceProperties.class, SleuthProperties.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.trace.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={StackdriverSender.class})
@AutoConfigureBefore(value={ZipkinAutoConfiguration.class, TraceAutoConfiguration.class})
public class StackdriverTraceAutoConfiguration {
    private GcpProjectIdProvider finalProjectIdProvider;
    private CredentialsProvider finalCredentialsProvider;
    private HeaderProvider headerProvider = new UsageTrackingHeaderProvider(this.getClass());

    public StackdriverTraceAutoConfiguration(GcpProjectIdProvider gcpProjectIdProvider, CredentialsProvider credentialsProvider, GcpTraceProperties gcpTraceProperties) throws IOException {
        this.finalProjectIdProvider = gcpTraceProperties.getProjectId() != null ? gcpTraceProperties::getProjectId : gcpProjectIdProvider;
        this.finalCredentialsProvider = gcpTraceProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpTraceProperties) : credentialsProvider;
    }

    @Bean
    @Primary
    public SleuthProperties stackdriverSleuthProperties(SleuthProperties sleuthProperties) {
        sleuthProperties.setSupportsJoin(false);
        sleuthProperties.setTraceId128(true);
        return sleuthProperties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"traceExecutorProvider"})
    public ExecutorProvider traceExecutorProvider(GcpTraceProperties traceProperties) {
        return FixedExecutorProvider.create((ScheduledExecutorService)Executors.newScheduledThreadPool(traceProperties.getNumExecutorThreads()));
    }

    @Bean
    @ConditionalOnMissingBean
    public Sender stackdriverSender(GcpTraceProperties traceProperties, @Qualifier(value="traceExecutorProvider") ExecutorProvider executorProvider) throws IOException {
        CallOptions callOptions = CallOptions.DEFAULT.withCallCredentials(MoreCallCredentials.from((Credentials)this.finalCredentialsProvider.getCredentials())).withExecutor((Executor)executorProvider.getExecutor());
        if (traceProperties.getAuthority() != null) {
            callOptions = callOptions.withAuthority(traceProperties.getAuthority());
        }
        if (traceProperties.getCompression() != null) {
            callOptions = callOptions.withCompression(traceProperties.getCompression());
        }
        if (traceProperties.getDeadlineMs() != null) {
            callOptions = callOptions.withDeadlineAfter(traceProperties.getDeadlineMs().longValue(), TimeUnit.MILLISECONDS);
        }
        if (traceProperties.getMaxInboundSize() != null) {
            callOptions = callOptions.withMaxInboundMessageSize(traceProperties.getMaxInboundSize().intValue());
        }
        if (traceProperties.getMaxOutboundSize() != null) {
            callOptions = callOptions.withMaxOutboundMessageSize(traceProperties.getMaxOutboundSize().intValue());
        }
        if (traceProperties.isWaitForReady() != null) {
            callOptions = Boolean.TRUE.equals(traceProperties.isWaitForReady()) ? callOptions.withWaitForReady() : callOptions.withoutWaitForReady();
        }
        return StackdriverSender.newBuilder().projectId(this.finalProjectIdProvider.getProjectId()).callOptions(callOptions).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public BytesEncoder<Span> spanBytesEncoder() {
        return StackdriverEncoder.V1;
    }

    @Bean
    @ConditionalOnMissingBean
    public Propagation.Factory stackdriverPropagation() {
        return StackdriverTracePropagation.FACTORY;
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.sleuth.http.enabled"}, havingValue="true", matchIfMissing=true)
    @AutoConfigureBefore(value={TraceHttpAutoConfiguration.class})
    public static class StackdriverTraceHttpAutoconfiguration {
        @Bean
        @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="false", matchIfMissing=true)
        @ConditionalOnMissingBean
        HttpClientParser stackdriverHttpClientParser() {
            return new StackdriverHttpClientParser();
        }

        @Bean
        @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="false", matchIfMissing=true)
        @ConditionalOnMissingBean
        HttpServerParser stackdriverHttpServerParser() {
            return new StackdriverHttpServerParser();
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.cloud.context.config.annotation.RefreshScope"})
    protected static class NonRefreshScopeProbabilityBasedSamplerConfiguration {
        protected NonRefreshScopeProbabilityBasedSamplerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new ProbabilityBasedSampler(config);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RefreshScope.class})
    protected static class RefreshScopedProbabilityBasedSamplerConfiguration {
        protected RefreshScopedProbabilityBasedSamplerConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new ProbabilityBasedSampler(config);
        }
    }
}

