/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.sql;

import org.springframework.cloud.gcp.autoconfigure.sql.CloudSqlJdbcInfoProvider;
import org.springframework.cloud.gcp.autoconfigure.sql.GcpCloudSqlProperties;
import org.springframework.util.Assert;

public class AppEngineCloudSqlJdbcInfoProvider
implements CloudSqlJdbcInfoProvider {
    private final GcpCloudSqlProperties properties;

    public AppEngineCloudSqlJdbcInfoProvider(GcpCloudSqlProperties properties) {
        this.properties = properties;
        Assert.hasText((String)properties.getDatabaseName(), (String)"A database name is required.");
        Assert.hasText((String)properties.getInstanceConnectionName(), (String)"An instance connection name must be provided. Refer to https://github.com/spring-cloud/spring-cloud-gcp/tree/master/spring-cloud-gcp-starters/spring-cloud-gcp-starter-sql#google-cloud-sql-instance-connection-name for more information.");
    }

    @Override
    public String getJdbcDriverClass() {
        return "com.mysql.jdbc.GoogleDriver";
    }

    @Override
    public String getJdbcUrl() {
        return String.format("jdbc:google:mysql://%s/%s", this.properties.getInstanceConnectionName(), this.properties.getDatabaseName());
    }
}

