/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route.builder;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.BooleanSpec;
import org.springframework.cloud.gateway.route.builder.PredicateSpec;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JA\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u001d\u0010\u0018\u001a\n \n*\u0004\u0018\u00010\u00190\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0086\u0004J\u001d\u0010\u001c\u001a\n \n*\u0004\u0018\u00010\u00190\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0086\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/springframework/cloud/gateway/route/builder/RouteLocatorDsl;", "", "builder", "Lorg/springframework/cloud/gateway/route/builder/RouteLocatorBuilder;", "<init>", "(Lorg/springframework/cloud/gateway/route/builder/RouteLocatorBuilder;)V", "getBuilder", "()Lorg/springframework/cloud/gateway/route/builder/RouteLocatorBuilder;", "routes", "Lorg/springframework/cloud/gateway/route/builder/RouteLocatorBuilder$Builder;", "kotlin.jvm.PlatformType", "route", "", "id", "", "order", "", "uri", "init", "Lkotlin/Function1;", "Lorg/springframework/cloud/gateway/route/builder/PredicateSpec;", "Lkotlin/ExtensionFunctionType;", "build", "Lorg/springframework/cloud/gateway/route/RouteLocator;", "and", "Lorg/springframework/cloud/gateway/route/Route$AsyncBuilder;", "Lorg/springframework/cloud/gateway/route/builder/BooleanSpec;", "other", "or", "spring-cloud-gateway-server"})
public final class RouteLocatorDsl {
    @NotNull
    private final RouteLocatorBuilder builder;
    private final RouteLocatorBuilder.Builder routes;

    public RouteLocatorDsl(@NotNull RouteLocatorBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.routes = this.builder.routes();
    }

    @NotNull
    public final RouteLocatorBuilder getBuilder() {
        return this.builder;
    }

    public final void route(@Nullable String id, int order, @Nullable String uri, @NotNull Function1<? super PredicateSpec, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        PredicateSpec predicateSpec = id == null ? new RouteLocatorBuilder.RouteSpec(this.routes).randomId() : new RouteLocatorBuilder.RouteSpec(this.routes).id(id);
        predicateSpec.order(order);
        if (uri != null) {
            predicateSpec.uri(uri);
        }
        PredicateSpec predicateSpec2 = predicateSpec;
        init.invoke((Object)predicateSpec2);
        Route.AsyncBuilder asyncBuilder = predicateSpec.routeBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)asyncBuilder, (String)"routeBuilder");
        Route.AsyncBuilder route = asyncBuilder;
        this.routes.add(route);
    }

    public static /* synthetic */ void route$default(RouteLocatorDsl routeLocatorDsl, String string, int n, String string2, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        routeLocatorDsl.route(string, n, string2, (Function1<? super PredicateSpec, Unit>)function1);
    }

    @NotNull
    public final RouteLocator build() {
        RouteLocator routeLocator = this.routes.build();
        Intrinsics.checkNotNullExpressionValue((Object)routeLocator, (String)"build(...)");
        return routeLocator;
    }

    public final Route.AsyncBuilder and(@NotNull BooleanSpec $this$and, @NotNull BooleanSpec other) {
        Intrinsics.checkNotNullParameter((Object)$this$and, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$and.routeBuilder.asyncPredicate($this$and.predicate.and(other.predicate));
    }

    public final Route.AsyncBuilder or(@NotNull BooleanSpec $this$or, @NotNull BooleanSpec other) {
        Intrinsics.checkNotNullParameter((Object)$this$or, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$or.routeBuilder.asyncPredicate($this$or.predicate.or(other.predicate));
    }
}

