/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.transport.SenderContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.PropagatingSenderTracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayContext;
import org.springframework.http.HttpHeaders;

public class GatewayPropagatingSenderTracingObservationHandler
extends PropagatingSenderTracingObservationHandler<GatewayContext> {
    private final Propagator propagator;
    private final List<String> remoteFieldsLowerCase;

    public GatewayPropagatingSenderTracingObservationHandler(Tracer tracer, Propagator propagator, List<String> remoteFields) {
        super(tracer, propagator);
        this.propagator = propagator;
        this.remoteFieldsLowerCase = remoteFields.stream().map(s -> s.toLowerCase(Locale.ROOT)).toList();
    }

    public void onStart(GatewayContext context) {
        this.propagator.fields().stream().filter(field -> !this.remoteFieldsLowerCase.contains(field.toLowerCase(Locale.ROOT))).forEach(s -> Objects.requireNonNull((HttpHeaders)context.getCarrier()).remove(s));
        super.onStart((SenderContext)context);
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof GatewayContext;
    }
}

