/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cloud.gateway.config.conditional.ConditionalOnEnabledFilter;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheProperties;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheManagerFactory;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheSizeWeigher;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.CacheKeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LocalResponseCacheProperties.class})
@ConditionalOnClass(value={Weigher.class, Caffeine.class, CaffeineCacheManager.class})
@ConditionalOnProperty(name={"spring.cloud.gateway.enabled"}, matchIfMissing=true)
@ConditionalOnEnabledFilter(value=LocalResponseCacheGatewayFilterFactory.class)
public class LocalResponseCacheAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(LocalResponseCacheAutoConfiguration.class);
    private static final String RESPONSE_CACHE_NAME = "response-cache";
    static final String RESPONSE_CACHE_MANAGER_NAME = "gatewayCacheManager";

    @Bean
    public LocalResponseCacheGatewayFilterFactory localResponseCacheGatewayFilterFactory(ResponseCacheManagerFactory responseCacheManagerFactory, @Qualifier(value="gatewayCacheManager") CacheManager cacheManager, LocalResponseCacheProperties properties) {
        return new LocalResponseCacheGatewayFilterFactory(responseCacheManagerFactory, this.responseCache(cacheManager), properties.getTimeToLive());
    }

    @Bean
    public ResponseCacheManagerFactory responseCacheManagerFactory(CacheKeyGenerator cacheKeyGenerator) {
        return new ResponseCacheManagerFactory(cacheKeyGenerator);
    }

    @Bean
    public CacheKeyGenerator cacheKeyGenerator() {
        return new CacheKeyGenerator();
    }

    @Bean(name={"gatewayCacheManager"})
    public static CacheManager gatewayCacheManager(LocalResponseCacheProperties cacheProperties) {
        CaffeineCacheManager caffeineCacheManager = new CaffeineCacheManager();
        caffeineCacheManager.setCaffeine(LocalResponseCacheAutoConfiguration.caffeine(cacheProperties));
        return caffeineCacheManager;
    }

    private static Caffeine caffeine(LocalResponseCacheProperties cacheProperties) {
        Caffeine caffeine = Caffeine.newBuilder();
        LOGGER.info((Object)"Initializing Caffeine");
        Duration ttlSeconds = cacheProperties.getTimeToLive();
        caffeine.expireAfterWrite(ttlSeconds);
        if (cacheProperties.getSize() != null) {
            caffeine.maximumWeight(cacheProperties.getSize().toBytes()).weigher((Weigher)LocalResponseCacheAutoConfiguration.responseCacheSizeWeigher());
        }
        return caffeine;
    }

    private static ResponseCacheSizeWeigher responseCacheSizeWeigher() {
        return new ResponseCacheSizeWeigher();
    }

    Cache responseCache(CacheManager cacheManager) {
        return cacheManager.getCache(RESPONSE_CACHE_NAME);
    }
}

