/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class OnEnabledComponent<T>
extends SpringBootCondition
implements ConfigurationCondition {
    private static final String PREFIX = "spring.cloud.gateway.";
    private static final String SUFFIX = ".enabled";

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Class<T> candidate = this.getComponentType(this.annotationClass(), context, metadata);
        return this.determineOutcome(candidate, (PropertyResolver)context.getEnvironment());
    }

    protected Class<? extends T> getComponentType(Class<?> annotationClass, ConditionContext context, AnnotatedTypeMetadata metadata) {
        Class target;
        Map attributes = metadata.getAnnotationAttributes(annotationClass.getName());
        if (attributes != null && attributes.containsKey("value") && (target = (Class)attributes.get("value")) != this.defaultValueClass()) {
            return target;
        }
        Assert.state((metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName()) ? 1 : 0) != 0, (String)(((Object)((Object)this)).getClass().getSimpleName() + " must be used on @Bean methods when the value is not specified"));
        MethodMetadata methodMetadata = (MethodMetadata)metadata;
        try {
            return ClassUtils.forName((String)methodMetadata.getReturnTypeName(), (ClassLoader)context.getClassLoader());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to extract component class for " + methodMetadata.getDeclaringClassName() + "." + methodMetadata.getMethodName(), ex);
        }
    }

    private ConditionOutcome determineOutcome(Class<? extends T> componentClass, PropertyResolver resolver) {
        String key = PREFIX + this.normalizeComponentName(componentClass) + SUFFIX;
        ConditionMessage.Builder messageBuilder = ConditionMessage.forCondition((String)this.annotationClass().getName(), (Object[])new Object[]{componentClass.getName()});
        if ("false".equalsIgnoreCase(resolver.getProperty(key))) {
            return ConditionOutcome.noMatch((ConditionMessage)messageBuilder.because("bean is not available"));
        }
        return ConditionOutcome.match();
    }

    protected abstract String normalizeComponentName(Class<? extends T> var1);

    protected abstract Class<?> annotationClass();

    protected abstract Class<? extends T> defaultValueClass();
}

