/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.springframework.cloud.gateway.server.mvc.common.AbstractProxyExchange;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.config.GatewayMvcProperties;
import org.springframework.cloud.gateway.server.mvc.handler.ClientHttpResponseAdapter;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayServerResponse;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchange;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestClient;
import org.springframework.web.servlet.function.ServerResponse;

public class RestClientProxyExchange
extends AbstractProxyExchange {
    private final RestClient restClient;

    public RestClientProxyExchange(RestClient restClient, GatewayMvcProperties properties) {
        super(properties);
        this.restClient = restClient;
    }

    @Override
    public ServerResponse exchange(ProxyExchange.Request request) {
        Objects.requireNonNull(request.getUri(), "uri cannot be null");
        RestClient.RequestBodySpec requestSpec = (RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.method(request.getMethod()).uri(request.getUri())).headers(httpHeaders -> httpHeaders.putAll(request.getHeaders()));
        if (RestClientProxyExchange.isBodyPresent(request)) {
            requestSpec.body(outputStream -> RestClientProxyExchange.copyBody(request, outputStream));
        }
        return (ServerResponse)requestSpec.exchange((clientRequest, clientResponse) -> this.doExchange(request, (ClientHttpResponse)clientResponse), false);
    }

    private static boolean isBodyPresent(ProxyExchange.Request request) {
        try {
            return !request.getServerRequest().servletRequest().getInputStream().isFinished();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int copyBody(ProxyExchange.Request request, OutputStream outputStream) throws IOException {
        return StreamUtils.copy((InputStream)request.getServerRequest().servletRequest().getInputStream(), (OutputStream)outputStream);
    }

    private ServerResponse doExchange(ProxyExchange.Request request, ClientHttpResponse clientResponse) throws IOException {
        InputStream body = clientResponse.getBody();
        MvcUtils.putAttribute(request.getServerRequest(), MvcUtils.CLIENT_RESPONSE_INPUT_STREAM_ATTR, body);
        MvcUtils.putAttribute(request.getServerRequest(), MvcUtils.CLIENT_RESPONSE_ATTR, clientResponse);
        ServerResponse serverResponse = GatewayServerResponse.status(clientResponse.getStatusCode()).build((req, httpServletResponse) -> {
            try (ClientHttpResponse twrVar0$ = clientResponse;){
                InputStream inputStream = (InputStream)MvcUtils.getAttribute(request.getServerRequest(), MvcUtils.CLIENT_RESPONSE_INPUT_STREAM_ATTR);
                Objects.requireNonNull(inputStream, "input stream cannot be null");
                this.copyResponseBody(clientResponse, inputStream, (OutputStream)httpServletResponse.getOutputStream());
            }
            return null;
        });
        ClientHttpResponseAdapter proxyExchangeResponse = new ClientHttpResponseAdapter(clientResponse);
        request.getResponseConsumers().forEach(responseConsumer -> responseConsumer.accept(proxyExchangeResponse, serverResponse));
        return serverResponse;
    }
}

