/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.server.mvc.handler.AbstractGatewayServerResponse;
import org.springframework.core.Conventions;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.RenderingResponse;
import org.springframework.web.servlet.function.ServerResponse;

final class GatewayRenderingResponseBuilder
implements RenderingResponse.Builder {
    private final String name;
    private HttpStatusCode status = HttpStatus.OK;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, Cookie> cookies = new LinkedMultiValueMap();
    private final Map<String, Object> model = new LinkedHashMap<String, Object>();

    GatewayRenderingResponseBuilder(RenderingResponse other) {
        Objects.requireNonNull(other, "RenderingResponse must not be null");
        this.name = other.name();
        this.status = other.statusCode();
        this.headers.putAll(other.headers());
        this.model.putAll(other.model());
    }

    GatewayRenderingResponseBuilder(String name) {
        Objects.requireNonNull(name, "Name must not be null");
        this.name = name;
    }

    public RenderingResponse.Builder status(HttpStatusCode status) {
        Objects.requireNonNull(status, "HttpStatusCode must not be null");
        this.status = status;
        return this;
    }

    public RenderingResponse.Builder status(int status) {
        return this.status(HttpStatusCode.valueOf((int)status));
    }

    public RenderingResponse.Builder cookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "Cookie must not be null");
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    public RenderingResponse.Builder cookies(Consumer<MultiValueMap<String, Cookie>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    public RenderingResponse.Builder modelAttribute(Object attribute) {
        Collection collection;
        Objects.requireNonNull(attribute, "Attribute must not be null");
        if (attribute instanceof Collection && (collection = (Collection)attribute).isEmpty()) {
            return this;
        }
        return this.modelAttribute(Conventions.getVariableName((Object)attribute), attribute);
    }

    public RenderingResponse.Builder modelAttribute(String name, @Nullable Object value) {
        Objects.requireNonNull(name, "Name must not be null");
        this.model.put(name, value);
        return this;
    }

    public RenderingResponse.Builder modelAttributes(Object ... attributes) {
        this.modelAttributes(Arrays.asList(attributes));
        return this;
    }

    public RenderingResponse.Builder modelAttributes(Collection<?> attributes) {
        attributes.forEach(this::modelAttribute);
        return this;
    }

    public RenderingResponse.Builder modelAttributes(Map<String, ?> attributes) {
        this.model.putAll(attributes);
        return this;
    }

    public RenderingResponse.Builder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    public RenderingResponse.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    public RenderingResponse build() {
        return new GatewayRenderingResponse(this.status, this.headers, this.cookies, this.name, this.model);
    }

    private static final class GatewayRenderingResponse
    extends AbstractGatewayServerResponse
    implements RenderingResponse {
        private final String name;
        private final Map<String, Object> model;

        GatewayRenderingResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, Cookie> cookies, String name, Map<String, Object> model) {
            super(statusCode, headers, cookies);
            this.name = name;
            this.model = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(model));
        }

        public String name() {
            return this.name;
        }

        public Map<String, Object> model() {
            return this.model;
        }

        @Override
        protected ModelAndView writeToInternal(HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) {
            ModelAndView mav = new ModelAndView(this.name, this.statusCode());
            mav.addAllObjects(this.model);
            return mav;
        }
    }
}

