/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

public class GatewayMvcMultipartResolver
extends StandardServletMultipartResolver {
    public boolean isMultipart(HttpServletRequest request) {
        return super.isMultipart(request);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        return new GatewayMultipartHttpServletRequest(request);
    }

    private static boolean isGatewayRequest(HttpServletRequest request) {
        return request.getAttribute(MvcUtils.GATEWAY_ROUTE_ID_ATTR) != null || request.getAttribute(MvcUtils.GATEWAY_REQUEST_URL_ATTR) != null;
    }

    static class GatewayMultipartHttpServletRequest
    extends StandardMultipartHttpServletRequest {
        GatewayMultipartHttpServletRequest(HttpServletRequest request) {
            super(request, true);
        }

        protected void initializeMultipart() {
            if (!GatewayMvcMultipartResolver.isGatewayRequest(this.getRequest())) {
                super.initializeMultipart();
            }
        }

        public Map<String, String[]> getParameterMap() {
            if (GatewayMvcMultipartResolver.isGatewayRequest(this.getRequest())) {
                return Collections.emptyMap();
            }
            return super.getParameterMap();
        }
    }
}

