/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.gateway.server.mvc.GatewayServerMvcAutoConfiguration;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={GatewayServerMvcAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.gateway.server.webmvc.enabled"}, matchIfMissing=true)
public class GatewayMvcClassPathWarningAutoConfiguration {
    private static final Log log = LogFactory.getLog(GatewayMvcClassPathWarningAutoConfiguration.class);
    private static final String BORDER = "\n\n**********************************************************\n\n";

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.web.servlet.DispatcherServlet"})
    protected static class WebMvcMissingFromClasspathConfiguration {
        public WebMvcMissingFromClasspathConfiguration() {
            log.warn((Object)"\n\n**********************************************************\n\nSpring Web MVC is missing from the classpath, which is required for Spring Cloud Gateway Server Web MVC. Please add spring-boot-starter-web dependency.\n\n**********************************************************\n\n");
        }
    }
}

