/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.gateway.server.mvc.handler.FunctionHandlerHeaderUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

final class FunctionHandlerRequestProcessingHelper {
    private static Log logger = LogFactory.getLog(FunctionHandlerRequestProcessingHelper.class);

    private FunctionHandlerRequestProcessingHelper() {
    }

    static ServerResponse processRequest(ServerRequest request, SimpleFunctionRegistry.FunctionInvocationWrapper function, Object argument, boolean eventStream, List<String> ignoredHeaders, List<String> requestOnlyHeaders) {
        return FunctionHandlerRequestProcessingHelper.processRequest(request, function, argument, eventStream, ignoredHeaders, requestOnlyHeaders, null);
    }

    static ServerResponse processRequest(ServerRequest request, SimpleFunctionRegistry.FunctionInvocationWrapper function, Object argument, boolean eventStream, List<String> ignoredHeaders, List<String> requestOnlyHeaders, Map<String, String> additionalHeaders) {
        if (argument == null) {
            argument = "";
        }
        if (function == null) {
            return ServerResponse.notFound().build();
        }
        HttpHeaders headers = request.headers().asHttpHeaders();
        Message inputMessage = null;
        MessageBuilder builder = MessageBuilder.withPayload((Object)argument);
        if (!CollectionUtils.isEmpty((Map)request.params())) {
            builder = builder.setHeader("http_request_param", (Object)request.params().toSingleValueMap());
        }
        if (!CollectionUtils.isEmpty(additionalHeaders)) {
            builder.copyHeaders(additionalHeaders);
        }
        inputMessage = builder.copyHeaders(headers.toSingleValueMap()).build();
        if (function.isRoutingFunction()) {
            function.setSkipOutputConversion(true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending request to " + function + " with argument: " + inputMessage));
        }
        Object result = function.apply((Object)inputMessage);
        if (function.isConsumer()) {
            return HttpMethod.DELETE.equals((Object)request.method()) ? ServerResponse.ok().build() : ((ServerResponse.BodyBuilder)ServerResponse.accepted().headers(h -> h.addAll(FunctionHandlerHeaderUtils.sanitize(headers, ignoredHeaders, requestOnlyHeaders)))).build();
        }
        ServerResponse.BodyBuilder responseOkBuilder = (ServerResponse.BodyBuilder)ServerResponse.ok().headers(h -> h.addAll(FunctionHandlerHeaderUtils.sanitize(headers, ignoredHeaders, requestOnlyHeaders)));
        if (result instanceof Iterable) {
            Iterable i = (Iterable)result;
            List aggregatedResult = StreamSupport.stream(i.spliterator(), false).map(m -> m instanceof Message ? FunctionHandlerRequestProcessingHelper.processMessage(responseOkBuilder, (Message)m, ignoredHeaders) : m).collect(Collectors.toList());
            return ((ServerResponse.BodyBuilder)responseOkBuilder.header("content-type", new String[]{"application/json"})).body(aggregatedResult);
        }
        if (result instanceof Message) {
            Message message = (Message)result;
            return responseOkBuilder.body(FunctionHandlerRequestProcessingHelper.processMessage(responseOkBuilder, message, ignoredHeaders));
        }
        return responseOkBuilder.body(result);
    }

    private static Object processMessage(ServerResponse.BodyBuilder responseOkBuilder, Message<?> message, List<String> ignoredHeaders) {
        responseOkBuilder.headers(h -> h.addAll(FunctionHandlerHeaderUtils.fromMessage(message.getHeaders(), ignoredHeaders)));
        return message.getPayload();
    }
}

