/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RewriteRequestParameterGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String REPLACEMENT_KEY = "replacement";

    public RewriteRequestParameterGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name", REPLACEMENT_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){
            final /* synthetic */ RewriteRequestParameterGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                String name = Objects.requireNonNull(config.getName(), "name must not be null");
                String replacement = Objects.requireNonNull(config.getReplacement(), "replacement must not be null");
                ServerHttpRequest req = exchange.getRequest();
                UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)req.getURI());
                LinkedMultiValueMap queryParams = new LinkedMultiValueMap((Map)req.getQueryParams());
                if (queryParams.containsKey((Object)name)) {
                    queryParams.remove((Object)name);
                    queryParams.add((Object)name, (Object)replacement);
                }
                try {
                    MultiValueMap<String, String> encodedQueryParams = ServerWebExchangeUtils.encodeQueryParams((MultiValueMap<String, String>)queryParams);
                    URI uri = uriComponentsBuilder.replaceQueryParams(CollectionUtils.unmodifiableMultiValueMap(encodedQueryParams)).build(true).toUri();
                    ServerHttpRequest request = req.mutate().uri(uri).build();
                    return chain.filter(exchange.mutate().request(request).build());
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException("Invalid URI query: \"" + String.valueOf(queryParams) + "\"");
                }
            }

            public String toString() {
                String name = Objects.requireNonNull(config.getName(), "name must not be null");
                String replacement = Objects.requireNonNull(config.getReplacement(), "replacement must not be null");
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append(name, (Object)replacement).toString();
            }
        };
    }

    public static class Config
    extends AbstractGatewayFilterFactory.NameConfig {
        private @Nullable String replacement;

        public @Nullable String getReplacement() {
            return this.replacement;
        }

        public Config setReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }
    }
}

