/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration;
import org.springframework.boot.webflux.autoconfigure.HttpHandlerAutoConfiguration;
import org.springframework.cloud.gateway.config.GatewayMetricsProperties;
import org.springframework.cloud.gateway.filter.GatewayMetricsFilter;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayObservationConvention;
import org.springframework.cloud.gateway.filter.headers.observation.ObservationClosingWebExceptionHandler;
import org.springframework.cloud.gateway.filter.headers.observation.ObservedRequestHttpHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.observation.ObservedResponseHttpHeadersFilter;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionMetrics;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayHttpTagsProvider;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayPathTagsProvider;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayRouteTagsProvider;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayTagsProvider;
import org.springframework.cloud.gateway.support.tagsprovider.PropertiesTagsProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.reactive.DispatcherHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.gateway.server.webflux.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GatewayMetricsProperties.class})
@AutoConfigureBefore(value={HttpHandlerAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, ObservationAutoConfiguration.class})
@ConditionalOnClass(value={DispatcherHandler.class, MeterRegistry.class, MetricsAutoConfiguration.class})
public class GatewayMetricsAutoConfiguration {
    @Bean
    public GatewayHttpTagsProvider gatewayHttpTagsProvider() {
        return new GatewayHttpTagsProvider();
    }

    @Bean
    @ConditionalOnExpression(value="'${spring.cloud.gateway.server.webflux.metrics.tags.path.enabled:false}' == 'true' || '${spring.cloud.gateway.server.webflux.metrics.path-tags.enabled:false}' == 'true'")
    public GatewayPathTagsProvider gatewayPathTagsProvider() {
        return new GatewayPathTagsProvider();
    }

    @Bean
    public GatewayRouteTagsProvider gatewayRouteTagsProvider() {
        return new GatewayRouteTagsProvider();
    }

    @Bean
    public PropertiesTagsProvider propertiesTagsProvider(GatewayMetricsProperties properties) {
        return new PropertiesTagsProvider(properties.getTags());
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(name={"spring.cloud.gateway.server.webflux.metrics.enabled"}, matchIfMissing=true)
    public GatewayMetricsFilter gatewayMetricFilter(MeterRegistry meterRegistry, List<GatewayTagsProvider> tagsProviders, GatewayMetricsProperties properties) {
        return new GatewayMetricsFilter(meterRegistry, tagsProviders, properties.getPrefix());
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(name={"spring.cloud.gateway.server.webflux.metrics.enabled"}, matchIfMissing=true)
    public RouteDefinitionMetrics routeDefinitionMetrics(MeterRegistry meterRegistry, RouteDefinitionLocator routeDefinitionLocator, GatewayMetricsProperties properties) {
        return new RouteDefinitionMetrics(meterRegistry, routeDefinitionLocator, properties.getPrefix());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ObservationRegistry.class})
    @ConditionalOnProperty(name={"spring.cloud.gateway.server.webflux.observability.enabled"}, matchIfMissing=true)
    static class ObservabilityConfiguration {
        ObservabilityConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ObservedRequestHttpHeadersFilter observedRequestHttpHeadersFilter(ObservationRegistry observationRegistry, ObjectProvider<GatewayObservationConvention> gatewayObservationConvention) {
            return new ObservedRequestHttpHeadersFilter(observationRegistry, (GatewayObservationConvention)gatewayObservationConvention.getIfAvailable(() -> null));
        }

        @Bean
        @ConditionalOnMissingBean
        ObservedResponseHttpHeadersFilter observedResponseHttpHeadersFilter() {
            return new ObservedResponseHttpHeadersFilter();
        }

        @Bean
        @Order(value=-2147483648)
        ObservationClosingWebExceptionHandler observationClosingWebExceptionHandler() {
            return new ObservationClosingWebExceptionHandler();
        }
    }
}

